/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.transform.CurrentRevisionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CurrentRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, CurrentRevision> {
    private final String revision;
    private final String changeIdentifier;
    private final Date created;
    private final String revisionSummary;

    private CurrentRevision(BuilderImpl builder) {
        this.revision = builder.revision;
        this.changeIdentifier = builder.changeIdentifier;
        this.created = builder.created;
        this.revisionSummary = builder.revisionSummary;
    }

    public String revision() {
        return this.revision;
    }

    public String changeIdentifier() {
        return this.changeIdentifier;
    }

    public Date created() {
        return this.created;
    }

    public String revisionSummary() {
        return this.revisionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        hashCode = 31 * hashCode + (this.changeIdentifier() == null ? 0 : this.changeIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.revisionSummary() == null ? 0 : this.revisionSummary().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentRevision)) {
            return false;
        }
        CurrentRevision other = (CurrentRevision)obj;
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.changeIdentifier() == null ^ this.changeIdentifier() == null) {
            return false;
        }
        if (other.changeIdentifier() != null && !other.changeIdentifier().equals(this.changeIdentifier())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.revisionSummary() == null ^ this.revisionSummary() == null) {
            return false;
        }
        return other.revisionSummary() == null || other.revisionSummary().equals(this.revisionSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.changeIdentifier() != null) {
            sb.append("ChangeIdentifier: ").append(this.changeIdentifier()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.revisionSummary() != null) {
            sb.append("RevisionSummary: ").append(this.revisionSummary()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CurrentRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String revision;
        private String changeIdentifier;
        private Date created;
        private String revisionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentRevision model) {
            this.setRevision(model.revision);
            this.setChangeIdentifier(model.changeIdentifier);
            this.setCreated(model.created);
            this.setRevisionSummary(model.revisionSummary);
        }

        public final String getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public final String getChangeIdentifier() {
            return this.changeIdentifier;
        }

        @Override
        public final Builder changeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
            return this;
        }

        public final void setChangeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
        }

        public final Date getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy((Date)created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy((Date)created);
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public CurrentRevision build() {
            return new CurrentRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CurrentRevision> {
        public Builder revision(String var1);

        public Builder changeIdentifier(String var1);

        public Builder created(Date var1);

        public Builder revisionSummary(String var1);
    }
}

