/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.CodeLine;
import software.amazon.awssdk.services.codegurusecurity.model.CodeSnippetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilePath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilePath> {
    private static final SdkField<List<CodeLine>> CODE_SNIPPET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codeSnippet").getter(FilePath.getter(FilePath::codeSnippet)).setter(FilePath.setter(Builder::codeSnippet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSnippet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> END_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("endLine").getter(FilePath.getter(FilePath::endLine)).setter(FilePath.setter(Builder::endLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endLine").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FilePath.getter(FilePath::name)).setter(FilePath.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(FilePath.getter(FilePath::path)).setter(FilePath.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> START_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startLine").getter(FilePath.getter(FilePath::startLine)).setter(FilePath.setter(Builder::startLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startLine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SNIPPET_FIELD, END_LINE_FIELD, NAME_FIELD, PATH_FIELD, START_LINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilePath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CodeLine> codeSnippet;
    private final Integer endLine;
    private final String name;
    private final String path;
    private final Integer startLine;

    private FilePath(BuilderImpl builder) {
        this.codeSnippet = builder.codeSnippet;
        this.endLine = builder.endLine;
        this.name = builder.name;
        this.path = builder.path;
        this.startLine = builder.startLine;
    }

    public final boolean hasCodeSnippet() {
        return this.codeSnippet != null && !(this.codeSnippet instanceof SdkAutoConstructList);
    }

    public final List<CodeLine> codeSnippet() {
        return this.codeSnippet;
    }

    public final Integer endLine() {
        return this.endLine;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final Integer startLine() {
        return this.startLine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeSnippet() ? this.codeSnippet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.startLine());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilePath)) {
            return false;
        }
        FilePath other = (FilePath)obj;
        return this.hasCodeSnippet() == other.hasCodeSnippet() && Objects.equals(this.codeSnippet(), other.codeSnippet()) && Objects.equals(this.endLine(), other.endLine()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.startLine(), other.startLine());
    }

    public final String toString() {
        return ToString.builder((String)"FilePath").add("CodeSnippet", this.hasCodeSnippet() ? this.codeSnippet() : null).add("EndLine", (Object)this.endLine()).add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("StartLine", (Object)this.startLine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeSnippet": {
                return Optional.ofNullable(clazz.cast(this.codeSnippet()));
            }
            case "endLine": {
                return Optional.ofNullable(clazz.cast(this.endLine()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "startLine": {
                return Optional.ofNullable(clazz.cast(this.startLine()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeSnippet", CODE_SNIPPET_FIELD);
        map.put("endLine", END_LINE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("path", PATH_FIELD);
        map.put("startLine", START_LINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilePath, T> g) {
        return obj -> g.apply((FilePath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CodeLine> codeSnippet = DefaultSdkAutoConstructList.getInstance();
        private Integer endLine;
        private String name;
        private String path;
        private Integer startLine;

        private BuilderImpl() {
        }

        private BuilderImpl(FilePath model) {
            this.codeSnippet(model.codeSnippet);
            this.endLine(model.endLine);
            this.name(model.name);
            this.path(model.path);
            this.startLine(model.startLine);
        }

        public final List<CodeLine.Builder> getCodeSnippet() {
            List<CodeLine.Builder> result = CodeSnippetCopier.copyToBuilder(this.codeSnippet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSnippet(Collection<CodeLine.BuilderImpl> codeSnippet) {
            this.codeSnippet = CodeSnippetCopier.copyFromBuilder(codeSnippet);
        }

        @Override
        public final Builder codeSnippet(Collection<CodeLine> codeSnippet) {
            this.codeSnippet = CodeSnippetCopier.copy(codeSnippet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(CodeLine ... codeSnippet) {
            this.codeSnippet(Arrays.asList(codeSnippet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeSnippet(Consumer<CodeLine.Builder> ... codeSnippet) {
            this.codeSnippet(Stream.of(codeSnippet).map(c -> (CodeLine)((CodeLine.Builder)CodeLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getEndLine() {
            return this.endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getStartLine() {
            return this.startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public FilePath build() {
            return new FilePath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilePath> {
        public Builder codeSnippet(Collection<CodeLine> var1);

        public Builder codeSnippet(CodeLine ... var1);

        public Builder codeSnippet(Consumer<CodeLine.Builder> ... var1);

        public Builder endLine(Integer var1);

        public Builder name(String var1);

        public Builder path(String var1);

        public Builder startLine(Integer var1);
    }
}

