/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClient;
import software.amazon.awssdk.services.codegurusecurity.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse;

public class ListFindingsMetricsPublisher
implements SdkPublisher<ListFindingsMetricsResponse> {
    private final CodeGuruSecurityAsyncClient client;
    private final ListFindingsMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsMetricsPublisher(CodeGuruSecurityAsyncClient client, ListFindingsMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsMetricsPublisher(CodeGuruSecurityAsyncClient client, ListFindingsMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountFindingsMetric> findingsMetrics() {
        Function<ListFindingsMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findingsMetrics() != null) {
                return response.findingsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingsMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingsMetricsResponseFetcher
    implements AsyncPageFetcher<ListFindingsMetricsResponse> {
        private ListFindingsMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsMetricsResponse> nextPage(ListFindingsMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsMetricsPublisher.this.client.listFindingsMetrics(ListFindingsMetricsPublisher.this.firstRequest);
            }
            return ListFindingsMetricsPublisher.this.client.listFindingsMetrics((ListFindingsMetricsRequest)((Object)ListFindingsMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

