/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityClient;
import software.amazon.awssdk.services.codegurusecurity.model.Finding;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsRequest;
import software.amazon.awssdk.services.codegurusecurity.model.GetFindingsResponse;

public class GetFindingsIterable
implements SdkIterable<GetFindingsResponse> {
    private final CodeGuruSecurityClient client;
    private final GetFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingsIterable(CodeGuruSecurityClient client, GetFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetFindingsResponseFetcher();
    }

    public Iterator<GetFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Finding> findings() {
        Function<GetFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingsResponseFetcher
    implements SyncPageFetcher<GetFindingsResponse> {
        private GetFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingsResponse nextPage(GetFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetFindingsIterable.this.client.getFindings(GetFindingsIterable.this.firstRequest);
            }
            return GetFindingsIterable.this.client.getFindings((GetFindingsRequest)((Object)GetFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

