/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.RecommendationCategory;
import software.amazon.awssdk.services.codegurureviewer.model.RuleMetadata;
import software.amazon.awssdk.services.codegurureviewer.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSummary> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(RecommendationSummary.getter(RecommendationSummary::filePath)).setter(RecommendationSummary.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(RecommendationSummary.getter(RecommendationSummary::recommendationId)).setter(RecommendationSummary.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<Integer> START_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartLine").getter(RecommendationSummary.getter(RecommendationSummary::startLine)).setter(RecommendationSummary.setter(Builder::startLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartLine").build()}).build();
    private static final SdkField<Integer> END_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndLine").getter(RecommendationSummary.getter(RecommendationSummary::endLine)).setter(RecommendationSummary.setter(Builder::endLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndLine").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RecommendationSummary.getter(RecommendationSummary::description)).setter(RecommendationSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RECOMMENDATION_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationCategory").getter(RecommendationSummary.getter(RecommendationSummary::recommendationCategoryAsString)).setter(RecommendationSummary.setter(Builder::recommendationCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationCategory").build()}).build();
    private static final SdkField<RuleMetadata> RULE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleMetadata").getter(RecommendationSummary.getter(RecommendationSummary::ruleMetadata)).setter(RecommendationSummary.setter(Builder::ruleMetadata)).constructor(RuleMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleMetadata").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(RecommendationSummary.getter(RecommendationSummary::severityAsString)).setter(RecommendationSummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, RECOMMENDATION_ID_FIELD, START_LINE_FIELD, END_LINE_FIELD, DESCRIPTION_FIELD, RECOMMENDATION_CATEGORY_FIELD, RULE_METADATA_FIELD, SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final String recommendationId;
    private final Integer startLine;
    private final Integer endLine;
    private final String description;
    private final String recommendationCategory;
    private final RuleMetadata ruleMetadata;
    private final String severity;

    private RecommendationSummary(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.recommendationId = builder.recommendationId;
        this.startLine = builder.startLine;
        this.endLine = builder.endLine;
        this.description = builder.description;
        this.recommendationCategory = builder.recommendationCategory;
        this.ruleMetadata = builder.ruleMetadata;
        this.severity = builder.severity;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final Integer startLine() {
        return this.startLine;
    }

    public final Integer endLine() {
        return this.endLine;
    }

    public final String description() {
        return this.description;
    }

    public final RecommendationCategory recommendationCategory() {
        return RecommendationCategory.fromValue(this.recommendationCategory);
    }

    public final String recommendationCategoryAsString() {
        return this.recommendationCategory;
    }

    public final RuleMetadata ruleMetadata() {
        return this.ruleMetadata;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.endLine());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.startLine(), other.startLine()) && Objects.equals(this.endLine(), other.endLine()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.recommendationCategoryAsString(), other.recommendationCategoryAsString()) && Objects.equals(this.ruleMetadata(), other.ruleMetadata()) && Objects.equals(this.severityAsString(), other.severityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSummary").add("FilePath", (Object)this.filePath()).add("RecommendationId", (Object)this.recommendationId()).add("StartLine", (Object)this.startLine()).add("EndLine", (Object)this.endLine()).add("Description", (Object)this.description()).add("RecommendationCategory", (Object)this.recommendationCategoryAsString()).add("RuleMetadata", (Object)this.ruleMetadata()).add("Severity", (Object)this.severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "StartLine": {
                return Optional.ofNullable(clazz.cast(this.startLine()));
            }
            case "EndLine": {
                return Optional.ofNullable(clazz.cast(this.endLine()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RecommendationCategory": {
                return Optional.ofNullable(clazz.cast(this.recommendationCategoryAsString()));
            }
            case "RuleMetadata": {
                return Optional.ofNullable(clazz.cast(this.ruleMetadata()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("StartLine", START_LINE_FIELD);
        map.put("EndLine", END_LINE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RecommendationCategory", RECOMMENDATION_CATEGORY_FIELD);
        map.put("RuleMetadata", RULE_METADATA_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private String recommendationId;
        private Integer startLine;
        private Integer endLine;
        private String description;
        private String recommendationCategory;
        private RuleMetadata ruleMetadata;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            this.filePath(model.filePath);
            this.recommendationId(model.recommendationId);
            this.startLine(model.startLine);
            this.endLine(model.endLine);
            this.description(model.description);
            this.recommendationCategory(model.recommendationCategory);
            this.ruleMetadata(model.ruleMetadata);
            this.severity(model.severity);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Integer getStartLine() {
            return this.startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public final Integer getEndLine() {
            return this.endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRecommendationCategory() {
            return this.recommendationCategory;
        }

        public final void setRecommendationCategory(String recommendationCategory) {
            this.recommendationCategory = recommendationCategory;
        }

        @Override
        public final Builder recommendationCategory(String recommendationCategory) {
            this.recommendationCategory = recommendationCategory;
            return this;
        }

        @Override
        public final Builder recommendationCategory(RecommendationCategory recommendationCategory) {
            this.recommendationCategory(recommendationCategory == null ? null : recommendationCategory.toString());
            return this;
        }

        public final RuleMetadata.Builder getRuleMetadata() {
            return this.ruleMetadata != null ? this.ruleMetadata.toBuilder() : null;
        }

        public final void setRuleMetadata(RuleMetadata.BuilderImpl ruleMetadata) {
            this.ruleMetadata = ruleMetadata != null ? ruleMetadata.build() : null;
        }

        @Override
        public final Builder ruleMetadata(RuleMetadata ruleMetadata) {
            this.ruleMetadata = ruleMetadata;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSummary> {
        public Builder filePath(String var1);

        public Builder recommendationId(String var1);

        public Builder startLine(Integer var1);

        public Builder endLine(Integer var1);

        public Builder description(String var1);

        public Builder recommendationCategory(String var1);

        public Builder recommendationCategory(RecommendationCategory var1);

        public Builder ruleMetadata(RuleMetadata var1);

        default public Builder ruleMetadata(Consumer<RuleMetadata.Builder> ruleMetadata) {
            return this.ruleMetadata((RuleMetadata)((RuleMetadata.Builder)RuleMetadata.builder().applyMutation(ruleMetadata)).build());
        }

        public Builder severity(String var1);

        public Builder severity(Severity var1);
    }
}

