/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.AnalysisType;
import software.amazon.awssdk.services.codegurureviewer.model.AnalysisTypesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAnalysis;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeReviewType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeReviewType> {
    private static final SdkField<RepositoryAnalysis> REPOSITORY_ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RepositoryAnalysis").getter(CodeReviewType.getter(CodeReviewType::repositoryAnalysis)).setter(CodeReviewType.setter(Builder::repositoryAnalysis)).constructor(RepositoryAnalysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAnalysis").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisTypes").getter(CodeReviewType.getter(CodeReviewType::analysisTypesAsStrings)).setter(CodeReviewType.setter(Builder::analysisTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ANALYSIS_FIELD, ANALYSIS_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeReviewType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RepositoryAnalysis repositoryAnalysis;
    private final List<String> analysisTypes;

    private CodeReviewType(BuilderImpl builder) {
        this.repositoryAnalysis = builder.repositoryAnalysis;
        this.analysisTypes = builder.analysisTypes;
    }

    public final RepositoryAnalysis repositoryAnalysis() {
        return this.repositoryAnalysis;
    }

    public final List<AnalysisType> analysisTypes() {
        return AnalysisTypesCopier.copyStringToEnum(this.analysisTypes);
    }

    public final boolean hasAnalysisTypes() {
        return this.analysisTypes != null && !(this.analysisTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisTypesAsStrings() {
        return this.analysisTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisTypes() ? this.analysisTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeReviewType)) {
            return false;
        }
        CodeReviewType other = (CodeReviewType)obj;
        return Objects.equals(this.repositoryAnalysis(), other.repositoryAnalysis()) && this.hasAnalysisTypes() == other.hasAnalysisTypes() && Objects.equals(this.analysisTypesAsStrings(), other.analysisTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CodeReviewType").add("RepositoryAnalysis", (Object)this.repositoryAnalysis()).add("AnalysisTypes", this.hasAnalysisTypes() ? this.analysisTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryAnalysis": {
                return Optional.ofNullable(clazz.cast(this.repositoryAnalysis()));
            }
            case "AnalysisTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RepositoryAnalysis", REPOSITORY_ANALYSIS_FIELD);
        map.put("AnalysisTypes", ANALYSIS_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeReviewType, T> g) {
        return obj -> g.apply((CodeReviewType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RepositoryAnalysis repositoryAnalysis;
        private List<String> analysisTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeReviewType model) {
            this.repositoryAnalysis(model.repositoryAnalysis);
            this.analysisTypesWithStrings(model.analysisTypes);
        }

        public final RepositoryAnalysis.Builder getRepositoryAnalysis() {
            return this.repositoryAnalysis != null ? this.repositoryAnalysis.toBuilder() : null;
        }

        public final void setRepositoryAnalysis(RepositoryAnalysis.BuilderImpl repositoryAnalysis) {
            this.repositoryAnalysis = repositoryAnalysis != null ? repositoryAnalysis.build() : null;
        }

        @Override
        public final Builder repositoryAnalysis(RepositoryAnalysis repositoryAnalysis) {
            this.repositoryAnalysis = repositoryAnalysis;
            return this;
        }

        public final Collection<String> getAnalysisTypes() {
            if (this.analysisTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisTypes;
        }

        public final void setAnalysisTypes(Collection<String> analysisTypes) {
            this.analysisTypes = AnalysisTypesCopier.copy(analysisTypes);
        }

        @Override
        public final Builder analysisTypesWithStrings(Collection<String> analysisTypes) {
            this.analysisTypes = AnalysisTypesCopier.copy(analysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisTypesWithStrings(String ... analysisTypes) {
            this.analysisTypesWithStrings(Arrays.asList(analysisTypes));
            return this;
        }

        @Override
        public final Builder analysisTypes(Collection<AnalysisType> analysisTypes) {
            this.analysisTypes = AnalysisTypesCopier.copyEnumToString(analysisTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisTypes(AnalysisType ... analysisTypes) {
            this.analysisTypes(Arrays.asList(analysisTypes));
            return this;
        }

        public CodeReviewType build() {
            return new CodeReviewType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeReviewType> {
        public Builder repositoryAnalysis(RepositoryAnalysis var1);

        default public Builder repositoryAnalysis(Consumer<RepositoryAnalysis.Builder> repositoryAnalysis) {
            return this.repositoryAnalysis((RepositoryAnalysis)((RepositoryAnalysis.Builder)RepositoryAnalysis.builder().applyMutation(repositoryAnalysis)).build());
        }

        public Builder analysisTypesWithStrings(Collection<String> var1);

        public Builder analysisTypesWithStrings(String ... var1);

        public Builder analysisTypes(Collection<AnalysisType> var1);

        public Builder analysisTypes(AnalysisType ... var1);
    }
}

