/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VendorName {
    GIT_HUB("GitHub"),
    GIT_LAB("GitLab"),
    NATIVE_S3("NativeS3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VendorName> VALUE_MAP;
    private final String value;

    private VendorName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VendorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VendorName> knownValues() {
        EnumSet<VendorName> knownValues = EnumSet.allOf(VendorName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VendorName.class, VendorName::toString);
    }
}

