/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VendorName {
    GIT_HUB("GitHub"),
    GIT_LAB("GitLab"),
    NATIVE_S3("NativeS3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VendorName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VendorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VendorName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VendorName> knownValues() {
        return Stream.of(VendorName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

