/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse;

public class ListRecommendationFeedbackPublisher
implements SdkPublisher<ListRecommendationFeedbackResponse> {
    private final CodeGuruReviewerAsyncClient client;
    private final ListRecommendationFeedbackRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationFeedbackPublisher(CodeGuruReviewerAsyncClient client, ListRecommendationFeedbackRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationFeedbackPublisher(CodeGuruReviewerAsyncClient client, ListRecommendationFeedbackRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationFeedbackResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationFeedbackResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecommendationFeedbackResponseFetcher
    implements AsyncPageFetcher<ListRecommendationFeedbackResponse> {
        private ListRecommendationFeedbackResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationFeedbackResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationFeedbackResponse> nextPage(ListRecommendationFeedbackResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationFeedbackPublisher.this.client.listRecommendationFeedback(ListRecommendationFeedbackPublisher.this.firstRequest);
            }
            return ListRecommendationFeedbackPublisher.this.client.listRecommendationFeedback((ListRecommendationFeedbackRequest)((Object)ListRecommendationFeedbackPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

