/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.model.AccessDeniedException;
import software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryRequest;
import software.amazon.awssdk.services.codegurureviewer.model.AssociateRepositoryResponse;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerException;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ConflictException;
import software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewRequest;
import software.amazon.awssdk.services.codegurureviewer.model.CreateCodeReviewResponse;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRecommendationFeedbackResponse;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse;
import software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DisassociateRepositoryResponse;
import software.amazon.awssdk.services.codegurureviewer.model.InternalServerException;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationFeedbackResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRepositoryAssociationsResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codegurureviewer.model.NotFoundException;
import software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackRequest;
import software.amazon.awssdk.services.codegurureviewer.model.PutRecommendationFeedbackResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codegurureviewer.model.TagResourceRequest;
import software.amazon.awssdk.services.codegurureviewer.model.TagResourceResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ThrottlingException;
import software.amazon.awssdk.services.codegurureviewer.model.UntagResourceRequest;
import software.amazon.awssdk.services.codegurureviewer.model.UntagResourceResponse;
import software.amazon.awssdk.services.codegurureviewer.model.ValidationException;
import software.amazon.awssdk.services.codegurureviewer.paginators.ListCodeReviewsIterable;
import software.amazon.awssdk.services.codegurureviewer.paginators.ListRecommendationFeedbackIterable;
import software.amazon.awssdk.services.codegurureviewer.paginators.ListRecommendationsIterable;
import software.amazon.awssdk.services.codegurureviewer.paginators.ListRepositoryAssociationsIterable;
import software.amazon.awssdk.services.codegurureviewer.transform.AssociateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.CreateCodeReviewRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.DescribeCodeReviewRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.DescribeRecommendationFeedbackRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.DescribeRepositoryAssociationRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.DisassociateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.ListCodeReviewsRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.ListRecommendationFeedbackRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.ListRepositoryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.PutRecommendationFeedbackRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codegurureviewer.waiters.CodeGuruReviewerWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCodeGuruReviewerClient
implements CodeGuruReviewerClient {
    private static final Logger log = Logger.loggerFor(DefaultCodeGuruReviewerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeGuruReviewerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codeguru-reviewer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateRepositoryResponse associateRepository(AssociateRepositoryRequest associateRepositoryRequest) throws InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, associateRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateRepository");
            AssociateRepositoryResponse associateRepositoryResponse = (AssociateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$associateRepository$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCodeReviewResponse createCodeReview(CreateCodeReviewRequest createCodeReviewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCodeReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, createCodeReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCodeReview");
            CreateCodeReviewResponse createCodeReviewResponse = (CreateCodeReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCodeReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCodeReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCodeReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCodeReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$createCodeReview$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCodeReviewResponse describeCodeReview(DescribeCodeReviewRequest describeCodeReviewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCodeReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, describeCodeReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCodeReview");
            DescribeCodeReviewResponse describeCodeReviewResponse = (DescribeCodeReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCodeReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCodeReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCodeReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCodeReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$describeCodeReview$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecommendationFeedbackResponse describeRecommendationFeedback(DescribeRecommendationFeedbackRequest describeRecommendationFeedbackRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecommendationFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, describeRecommendationFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecommendationFeedback");
            DescribeRecommendationFeedbackResponse describeRecommendationFeedbackResponse = (DescribeRecommendationFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecommendationFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecommendationFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecommendationFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecommendationFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$describeRecommendationFeedback$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRepositoryAssociationResponse describeRepositoryAssociation(DescribeRepositoryAssociationRequest describeRepositoryAssociationRequest) throws NotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRepositoryAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, describeRepositoryAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRepositoryAssociation");
            DescribeRepositoryAssociationResponse describeRepositoryAssociationResponse = (DescribeRepositoryAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRepositoryAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRepositoryAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRepositoryAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRepositoryAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$describeRepositoryAssociation$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateRepositoryResponse disassociateRepository(DisassociateRepositoryRequest disassociateRepositoryRequest) throws NotFoundException, InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, disassociateRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateRepository");
            DisassociateRepositoryResponse disassociateRepositoryResponse = (DisassociateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$disassociateRepository$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCodeReviewsResponse listCodeReviews(ListCodeReviewsRequest listCodeReviewsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCodeReviewsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, listCodeReviewsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCodeReviews");
            ListCodeReviewsResponse listCodeReviewsResponse = (ListCodeReviewsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCodeReviews").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCodeReviewsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCodeReviewsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCodeReviewsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$listCodeReviews$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCodeReviewsIterable listCodeReviewsPaginator(ListCodeReviewsRequest listCodeReviewsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        return new ListCodeReviewsIterable(this, this.applyPaginatorUserAgent(listCodeReviewsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationFeedbackResponse listRecommendationFeedback(ListRecommendationFeedbackRequest listRecommendationFeedbackRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, listRecommendationFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendationFeedback");
            ListRecommendationFeedbackResponse listRecommendationFeedbackResponse = (ListRecommendationFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendationFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecommendationFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$listRecommendationFeedback$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecommendationFeedbackIterable listRecommendationFeedbackPaginator(ListRecommendationFeedbackRequest listRecommendationFeedbackRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        return new ListRecommendationFeedbackIterable(this, this.applyPaginatorUserAgent(listRecommendationFeedbackRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, listRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendations");
            ListRecommendationsResponse listRecommendationsResponse = (ListRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$listRecommendations$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        return new ListRecommendationsIterable(this, this.applyPaginatorUserAgent(listRecommendationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRepositoryAssociationsResponse listRepositoryAssociations(ListRepositoryAssociationsRequest listRepositoryAssociationsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoryAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, listRepositoryAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositoryAssociations");
            ListRepositoryAssociationsResponse listRepositoryAssociationsResponse = (ListRepositoryAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositoryAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositoryAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRepositoryAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRepositoryAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$listRepositoryAssociations$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRepositoryAssociationsIterable listRepositoryAssociationsPaginator(ListRepositoryAssociationsRequest listRepositoryAssociationsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        return new ListRepositoryAssociationsIterable(this, this.applyPaginatorUserAgent(listRepositoryAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$listTagsForResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecommendationFeedbackResponse putRecommendationFeedback(PutRecommendationFeedbackRequest putRecommendationFeedbackRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecommendationFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, putRecommendationFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRecommendationFeedback");
            PutRecommendationFeedbackResponse putRecommendationFeedbackResponse = (PutRecommendationFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecommendationFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecommendationFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRecommendationFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRecommendationFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$putRecommendationFeedback$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$tagResource$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeGuruReviewerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCodeGuruReviewerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeGuru Reviewer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeGuruReviewerClient.lambda$untagResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeGuruReviewerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CodeGuruReviewerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.18").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeGuruReviewerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public CodeGuruReviewerWaiter waiter() {
        return CodeGuruReviewerWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$untagResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRecommendationFeedback$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositoryAssociations$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendations$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendationFeedback$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCodeReviews$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateRepository$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRepositoryAssociation$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecommendationFeedback$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCodeReview$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCodeReview$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateRepository$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

