/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.CodeCommitRepository;
import software.amazon.awssdk.services.codegurureviewer.model.ThirdPartySourceRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Repository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Repository> {
    private static final SdkField<CodeCommitRepository> CODE_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeCommit").getter(Repository.getter(Repository::codeCommit)).setter(Repository.setter(Builder::codeCommit)).constructor(CodeCommitRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeCommit").build()}).build();
    private static final SdkField<ThirdPartySourceRepository> BITBUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bitbucket").getter(Repository.getter(Repository::bitbucket)).setter(Repository.setter(Builder::bitbucket)).constructor(ThirdPartySourceRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bitbucket").build()}).build();
    private static final SdkField<ThirdPartySourceRepository> GIT_HUB_ENTERPRISE_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GitHubEnterpriseServer").getter(Repository.getter(Repository::gitHubEnterpriseServer)).setter(Repository.setter(Builder::gitHubEnterpriseServer)).constructor(ThirdPartySourceRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubEnterpriseServer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_COMMIT_FIELD, BITBUCKET_FIELD, GIT_HUB_ENTERPRISE_SERVER_FIELD));
    private static final long serialVersionUID = 1L;
    private final CodeCommitRepository codeCommit;
    private final ThirdPartySourceRepository bitbucket;
    private final ThirdPartySourceRepository gitHubEnterpriseServer;

    private Repository(BuilderImpl builder) {
        this.codeCommit = builder.codeCommit;
        this.bitbucket = builder.bitbucket;
        this.gitHubEnterpriseServer = builder.gitHubEnterpriseServer;
    }

    public CodeCommitRepository codeCommit() {
        return this.codeCommit;
    }

    public ThirdPartySourceRepository bitbucket() {
        return this.bitbucket;
    }

    public ThirdPartySourceRepository gitHubEnterpriseServer() {
        return this.gitHubEnterpriseServer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitbucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHubEnterpriseServer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)obj;
        return Objects.equals(this.codeCommit(), other.codeCommit()) && Objects.equals(this.bitbucket(), other.bitbucket()) && Objects.equals(this.gitHubEnterpriseServer(), other.gitHubEnterpriseServer());
    }

    public String toString() {
        return ToString.builder((String)"Repository").add("CodeCommit", (Object)this.codeCommit()).add("Bitbucket", (Object)this.bitbucket()).add("GitHubEnterpriseServer", (Object)this.gitHubEnterpriseServer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeCommit": {
                return Optional.ofNullable(clazz.cast(this.codeCommit()));
            }
            case "Bitbucket": {
                return Optional.ofNullable(clazz.cast(this.bitbucket()));
            }
            case "GitHubEnterpriseServer": {
                return Optional.ofNullable(clazz.cast(this.gitHubEnterpriseServer()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeCommitRepository codeCommit;
        private ThirdPartySourceRepository bitbucket;
        private ThirdPartySourceRepository gitHubEnterpriseServer;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            this.codeCommit(model.codeCommit);
            this.bitbucket(model.bitbucket);
            this.gitHubEnterpriseServer(model.gitHubEnterpriseServer);
        }

        public final CodeCommitRepository.Builder getCodeCommit() {
            return this.codeCommit != null ? this.codeCommit.toBuilder() : null;
        }

        @Override
        public final Builder codeCommit(CodeCommitRepository codeCommit) {
            this.codeCommit = codeCommit;
            return this;
        }

        public final void setCodeCommit(CodeCommitRepository.BuilderImpl codeCommit) {
            this.codeCommit = codeCommit != null ? codeCommit.build() : null;
        }

        public final ThirdPartySourceRepository.Builder getBitbucket() {
            return this.bitbucket != null ? this.bitbucket.toBuilder() : null;
        }

        @Override
        public final Builder bitbucket(ThirdPartySourceRepository bitbucket) {
            this.bitbucket = bitbucket;
            return this;
        }

        public final void setBitbucket(ThirdPartySourceRepository.BuilderImpl bitbucket) {
            this.bitbucket = bitbucket != null ? bitbucket.build() : null;
        }

        public final ThirdPartySourceRepository.Builder getGitHubEnterpriseServer() {
            return this.gitHubEnterpriseServer != null ? this.gitHubEnterpriseServer.toBuilder() : null;
        }

        @Override
        public final Builder gitHubEnterpriseServer(ThirdPartySourceRepository gitHubEnterpriseServer) {
            this.gitHubEnterpriseServer = gitHubEnterpriseServer;
            return this;
        }

        public final void setGitHubEnterpriseServer(ThirdPartySourceRepository.BuilderImpl gitHubEnterpriseServer) {
            this.gitHubEnterpriseServer = gitHubEnterpriseServer != null ? gitHubEnterpriseServer.build() : null;
        }

        public Repository build() {
            return new Repository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Repository> {
        public Builder codeCommit(CodeCommitRepository var1);

        default public Builder codeCommit(Consumer<CodeCommitRepository.Builder> codeCommit) {
            return this.codeCommit((CodeCommitRepository)((CodeCommitRepository.Builder)CodeCommitRepository.builder().applyMutation(codeCommit)).build());
        }

        public Builder bitbucket(ThirdPartySourceRepository var1);

        default public Builder bitbucket(Consumer<ThirdPartySourceRepository.Builder> bitbucket) {
            return this.bitbucket((ThirdPartySourceRepository)((ThirdPartySourceRepository.Builder)ThirdPartySourceRepository.builder().applyMutation(bitbucket)).build());
        }

        public Builder gitHubEnterpriseServer(ThirdPartySourceRepository var1);

        default public Builder gitHubEnterpriseServer(Consumer<ThirdPartySourceRepository.Builder> gitHubEnterpriseServer) {
            return this.gitHubEnterpriseServer((ThirdPartySourceRepository)((ThirdPartySourceRepository.Builder)ThirdPartySourceRepository.builder().applyMutation(gitHubEnterpriseServer)).build());
        }
    }
}

