/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeguruprofiler.CodeGuruProfilerClient;
import software.amazon.awssdk.services.codeguruprofiler.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ProfileTime;

public class ListProfileTimesIterable
implements SdkIterable<ListProfileTimesResponse> {
    private final CodeGuruProfilerClient client;
    private final ListProfileTimesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileTimesIterable(CodeGuruProfilerClient client, ListProfileTimesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfileTimesResponseFetcher();
    }

    public Iterator<ListProfileTimesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProfileTime> profileTimes() {
        Function<ListProfileTimesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileTimes() != null) {
                return response.profileTimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProfileTimesResponseFetcher
    implements SyncPageFetcher<ListProfileTimesResponse> {
        private ListProfileTimesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileTimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileTimesResponse nextPage(ListProfileTimesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileTimesIterable.this.client.listProfileTimes(ListProfileTimesIterable.this.firstRequest);
            }
            return ListProfileTimesIterable.this.client.listProfileTimes((ListProfileTimesRequest)((Object)ListProfileTimesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

