/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Match
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Match> {
    private static final SdkField<String> FRAME_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameAddress").getter(Match.getter(Match::frameAddress)).setter(Match.setter(Builder::frameAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameAddress").build()}).build();
    private static final SdkField<Integer> TARGET_FRAMES_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetFramesIndex").getter(Match.getter(Match::targetFramesIndex)).setter(Match.setter(Builder::targetFramesIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFramesIndex").build()}).build();
    private static final SdkField<Double> THRESHOLD_BREACH_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("thresholdBreachValue").getter(Match.getter(Match::thresholdBreachValue)).setter(Match.setter(Builder::thresholdBreachValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdBreachValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_ADDRESS_FIELD, TARGET_FRAMES_INDEX_FIELD, THRESHOLD_BREACH_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Match.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String frameAddress;
    private final Integer targetFramesIndex;
    private final Double thresholdBreachValue;

    private Match(BuilderImpl builder) {
        this.frameAddress = builder.frameAddress;
        this.targetFramesIndex = builder.targetFramesIndex;
        this.thresholdBreachValue = builder.thresholdBreachValue;
    }

    public final String frameAddress() {
        return this.frameAddress;
    }

    public final Integer targetFramesIndex() {
        return this.targetFramesIndex;
    }

    public final Double thresholdBreachValue() {
        return this.thresholdBreachValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFramesIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdBreachValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Match)) {
            return false;
        }
        Match other = (Match)obj;
        return Objects.equals(this.frameAddress(), other.frameAddress()) && Objects.equals(this.targetFramesIndex(), other.targetFramesIndex()) && Objects.equals(this.thresholdBreachValue(), other.thresholdBreachValue());
    }

    public final String toString() {
        return ToString.builder((String)"Match").add("FrameAddress", (Object)this.frameAddress()).add("TargetFramesIndex", (Object)this.targetFramesIndex()).add("ThresholdBreachValue", (Object)this.thresholdBreachValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameAddress": {
                return Optional.ofNullable(clazz.cast(this.frameAddress()));
            }
            case "targetFramesIndex": {
                return Optional.ofNullable(clazz.cast(this.targetFramesIndex()));
            }
            case "thresholdBreachValue": {
                return Optional.ofNullable(clazz.cast(this.thresholdBreachValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frameAddress", FRAME_ADDRESS_FIELD);
        map.put("targetFramesIndex", TARGET_FRAMES_INDEX_FIELD);
        map.put("thresholdBreachValue", THRESHOLD_BREACH_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Match, T> g) {
        return obj -> g.apply((Match)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frameAddress;
        private Integer targetFramesIndex;
        private Double thresholdBreachValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Match model) {
            this.frameAddress(model.frameAddress);
            this.targetFramesIndex(model.targetFramesIndex);
            this.thresholdBreachValue(model.thresholdBreachValue);
        }

        public final String getFrameAddress() {
            return this.frameAddress;
        }

        public final void setFrameAddress(String frameAddress) {
            this.frameAddress = frameAddress;
        }

        @Override
        public final Builder frameAddress(String frameAddress) {
            this.frameAddress = frameAddress;
            return this;
        }

        public final Integer getTargetFramesIndex() {
            return this.targetFramesIndex;
        }

        public final void setTargetFramesIndex(Integer targetFramesIndex) {
            this.targetFramesIndex = targetFramesIndex;
        }

        @Override
        public final Builder targetFramesIndex(Integer targetFramesIndex) {
            this.targetFramesIndex = targetFramesIndex;
            return this;
        }

        public final Double getThresholdBreachValue() {
            return this.thresholdBreachValue;
        }

        public final void setThresholdBreachValue(Double thresholdBreachValue) {
            this.thresholdBreachValue = thresholdBreachValue;
        }

        @Override
        public final Builder thresholdBreachValue(Double thresholdBreachValue) {
            this.thresholdBreachValue = thresholdBreachValue;
            return this;
        }

        public Match build() {
            return new Match(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Match> {
        public Builder frameAddress(String var1);

        public Builder targetFramesIndex(Integer var1);

        public Builder thresholdBreachValue(Double var1);
    }
}

