/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.AnomaliesCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.Anomaly;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.Recommendation;
import software.amazon.awssdk.services.codeguruprofiler.model.RecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationsResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, GetRecommendationsResponse> {
    private static final SdkField<List<Anomaly>> ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("anomalies").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::anomalies)).setter(GetRecommendationsResponse.setter(Builder::anomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Anomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> PROFILE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("profileEndTime").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::profileEndTime)).setter(GetRecommendationsResponse.setter(Builder::profileEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> PROFILE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("profileStartTime").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::profileStartTime)).setter(GetRecommendationsResponse.setter(Builder::profileStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::profilingGroupName)).setter(GetRecommendationsResponse.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build()}).build();
    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendations").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::recommendations)).setter(GetRecommendationsResponse.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALIES_FIELD, PROFILE_END_TIME_FIELD, PROFILE_START_TIME_FIELD, PROFILING_GROUP_NAME_FIELD, RECOMMENDATIONS_FIELD));
    private final List<Anomaly> anomalies;
    private final Instant profileEndTime;
    private final Instant profileStartTime;
    private final String profilingGroupName;
    private final List<Recommendation> recommendations;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalies = builder.anomalies;
        this.profileEndTime = builder.profileEndTime;
        this.profileStartTime = builder.profileStartTime;
        this.profilingGroupName = builder.profilingGroupName;
        this.recommendations = builder.recommendations;
    }

    public final boolean hasAnomalies() {
        return this.anomalies != null && !(this.anomalies instanceof SdkAutoConstructList);
    }

    public final List<Anomaly> anomalies() {
        return this.anomalies;
    }

    public final Instant profileEndTime() {
        return this.profileEndTime;
    }

    public final Instant profileStartTime() {
        return this.profileStartTime;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<Recommendation> recommendations() {
        return this.recommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalies() ? this.anomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profileEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse)((Object)obj);
        return this.hasAnomalies() == other.hasAnomalies() && Objects.equals(this.anomalies(), other.anomalies()) && Objects.equals(this.profileEndTime(), other.profileEndTime()) && Objects.equals(this.profileStartTime(), other.profileStartTime()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName()) && this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationsResponse").add("Anomalies", this.hasAnomalies() ? this.anomalies() : null).add("ProfileEndTime", (Object)this.profileEndTime()).add("ProfileStartTime", (Object)this.profileStartTime()).add("ProfilingGroupName", (Object)this.profilingGroupName()).add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalies": {
                return Optional.ofNullable(clazz.cast(this.anomalies()));
            }
            case "profileEndTime": {
                return Optional.ofNullable(clazz.cast(this.profileEndTime()));
            }
            case "profileStartTime": {
                return Optional.ofNullable(clazz.cast(this.profileStartTime()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
            case "recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private List<Anomaly> anomalies = DefaultSdkAutoConstructList.getInstance();
        private Instant profileEndTime;
        private Instant profileStartTime;
        private String profilingGroupName;
        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            this.anomalies(model.anomalies);
            this.profileEndTime(model.profileEndTime);
            this.profileStartTime(model.profileStartTime);
            this.profilingGroupName(model.profilingGroupName);
            this.recommendations(model.recommendations);
        }

        public final List<Anomaly.Builder> getAnomalies() {
            List<Anomaly.Builder> result = AnomaliesCopier.copyToBuilder(this.anomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder anomalies(Collection<Anomaly> anomalies) {
            this.anomalies = AnomaliesCopier.copy(anomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Anomaly ... anomalies) {
            this.anomalies(Arrays.asList(anomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalies(Consumer<Anomaly.Builder> ... anomalies) {
            this.anomalies(Stream.of(anomalies).map(c -> (Anomaly)((Anomaly.Builder)Anomaly.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalies(Collection<Anomaly.BuilderImpl> anomalies) {
            this.anomalies = AnomaliesCopier.copyFromBuilder(anomalies);
        }

        public final Instant getProfileEndTime() {
            return this.profileEndTime;
        }

        @Override
        public final Builder profileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
            return this;
        }

        public final void setProfileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
        }

        public final Instant getProfileStartTime() {
            return this.profileStartTime;
        }

        @Override
        public final Builder profileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
            return this;
        }

        public final void setProfileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final List<Recommendation.Builder> getRecommendations() {
            List<Recommendation.Builder> result = RecommendationsCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationsResponse> {
        public Builder anomalies(Collection<Anomaly> var1);

        public Builder anomalies(Anomaly ... var1);

        public Builder anomalies(Consumer<Anomaly.Builder> ... var1);

        public Builder profileEndTime(Instant var1);

        public Builder profileStartTime(Instant var1);

        public Builder profilingGroupName(String var1);

        public Builder recommendations(Collection<Recommendation> var1);

        public Builder recommendations(Recommendation ... var1);

        public Builder recommendations(Consumer<Recommendation.Builder> ... var1);
    }
}

