/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.MetadataCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.MetadataField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureAgentRequest
extends CodeGuruProfilerRequest
implements ToCopyableBuilder<Builder, ConfigureAgentRequest> {
    private static final SdkField<String> FLEET_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetInstanceId").getter(ConfigureAgentRequest.getter(ConfigureAgentRequest::fleetInstanceId)).setter(ConfigureAgentRequest.setter(Builder::fleetInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetInstanceId").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(ConfigureAgentRequest.getter(ConfigureAgentRequest::metadataAsStrings)).setter(ConfigureAgentRequest.setter(Builder::metadataWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profilingGroupName").getter(ConfigureAgentRequest.getter(ConfigureAgentRequest::profilingGroupName)).setter(ConfigureAgentRequest.setter(Builder::profilingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_INSTANCE_ID_FIELD, METADATA_FIELD, PROFILING_GROUP_NAME_FIELD));
    private final String fleetInstanceId;
    private final Map<String, String> metadata;
    private final String profilingGroupName;

    private ConfigureAgentRequest(BuilderImpl builder) {
        super(builder);
        this.fleetInstanceId = builder.fleetInstanceId;
        this.metadata = builder.metadata;
        this.profilingGroupName = builder.profilingGroupName;
    }

    public final String fleetInstanceId() {
        return this.fleetInstanceId;
    }

    public final Map<MetadataField, String> metadata() {
        return MetadataCopier.copyStringToEnum(this.metadata);
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadataAsStrings() {
        return this.metadata;
    }

    public final String profilingGroupName() {
        return this.profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadataAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAgentRequest)) {
            return false;
        }
        ConfigureAgentRequest other = (ConfigureAgentRequest)((Object)obj);
        return Objects.equals(this.fleetInstanceId(), other.fleetInstanceId()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadataAsStrings(), other.metadataAsStrings()) && Objects.equals(this.profilingGroupName(), other.profilingGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureAgentRequest").add("FleetInstanceId", (Object)this.fleetInstanceId()).add("Metadata", this.hasMetadata() ? this.metadataAsStrings() : null).add("ProfilingGroupName", (Object)this.profilingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fleetInstanceId": {
                return Optional.ofNullable(clazz.cast(this.fleetInstanceId()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadataAsStrings()));
            }
            case "profilingGroupName": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAgentRequest, T> g) {
        return obj -> g.apply((ConfigureAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerRequest.BuilderImpl
    implements Builder {
        private String fleetInstanceId;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAgentRequest model) {
            super(model);
            this.fleetInstanceId(model.fleetInstanceId);
            this.metadataWithStrings(model.metadata);
            this.profilingGroupName(model.profilingGroupName);
        }

        public final String getFleetInstanceId() {
            return this.fleetInstanceId;
        }

        @Override
        public final Builder fleetInstanceId(String fleetInstanceId) {
            this.fleetInstanceId = fleetInstanceId;
            return this;
        }

        public final void setFleetInstanceId(String fleetInstanceId) {
            this.fleetInstanceId = fleetInstanceId;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        @Override
        public final Builder metadataWithStrings(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        @Override
        public final Builder metadata(Map<MetadataField, String> metadata) {
            this.metadata = MetadataCopier.copyEnumToString(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureAgentRequest build() {
            return new ConfigureAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureAgentRequest> {
        public Builder fleetInstanceId(String var1);

        public Builder metadataWithStrings(Map<String, String> var1);

        public Builder metadata(Map<MetadataField, String> var1);

        public Builder profilingGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

