/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActionGroup {
    AGENT_PERMISSIONS("agentPermissions"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActionGroup(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionGroup fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActionGroup.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionGroup> knownValues() {
        return Stream.of(ActionGroup.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

