/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.awssdk.utils.CollectionUtils;

public class PaginatorDefinition {
    private static final String VALID_REGEX = "[a-zA-Z\\.]+";
    @JsonProperty(value="input_token")
    private List<String> inputToken;
    @JsonProperty(value="output_token")
    private List<String> outputToken;
    @JsonProperty(value="result_key")
    private List<String> resultKey;
    @JsonProperty(value="more_results")
    private String moreResults;
    @JsonProperty(value="limit_key")
    private String limitKey;

    public List<String> getInputToken() {
        return this.inputToken;
    }

    public void setInputToken(List<String> inputToken) {
        this.inputToken = inputToken;
    }

    public List<String> getOutputToken() {
        return this.outputToken;
    }

    public void setOutputToken(List<String> outputToken) {
        this.outputToken = outputToken;
    }

    public List<String> getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(List<String> resultKey) {
        this.resultKey = resultKey;
    }

    public String getMoreResults() {
        return this.moreResults;
    }

    public void setMoreResults(String moreResults) {
        this.moreResults = moreResults;
    }

    public String getLimitKey() {
        return this.limitKey;
    }

    public void setLimitKey(String limitKey) {
        this.limitKey = limitKey;
    }

    public boolean isValid() {
        Pattern p = Pattern.compile(VALID_REGEX);
        return !CollectionUtils.isNullOrEmpty(this.inputToken) && !CollectionUtils.isNullOrEmpty(this.outputToken) && this.outputToken.stream().allMatch(t -> p.matcher((CharSequence)t).matches());
    }
}

