/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.Ec2ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.XmlProtocolSpec;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;

public class SyncClientClass
implements ClassSpec {
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;

    public SyncClientClass(GeneratorTaskParams taskParams) {
        this.model = taskParams.getModel();
        this.poetExtensions = taskParams.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model);
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addField(SyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(SdkClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(this.constructor()).addMethod(this.nameMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethods(this.operations());
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        classBuilder.addMethod(this.protocolSpec.initProtocolFactory(this.model));
        classBuilder.addMethod(this.closeMethod());
        if (this.model.hasPaginators()) {
            classBuilder.addMethod(ClientClassUtils.applyPaginatorUserAgentMethod(this.poetExtensions, this.model));
        }
        if (this.model.containsRequestSigners()) {
            classBuilder.addMethod(ClientClassUtils.applySignerOverrideMethod(this.poetExtensions, this.model));
        }
        this.model.getEndpointOperation().ifPresent(o -> classBuilder.addField(EndpointDiscoveryRefreshCache.class, "endpointDiscoveryCache", new Modifier[]{Modifier.PRIVATE}));
        return classBuilder.build();
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return SERVICE_NAME", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private MethodSpec constructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]);
        FieldSpec protocolFactoryField = this.protocolSpec.protocolFactory(this.model);
        if (this.model.getMetadata().isJsonProtocol()) {
            builder.addStatement("this.$N = init($T.builder()).build()", new Object[]{protocolFactoryField.name, protocolFactoryField.type});
        } else {
            builder.addStatement("this.$N = init()", new Object[]{protocolFactoryField.name});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED))", new Object[0]);
            builder.addStatement("this.endpointDiscoveryCache = $T.create($T.create(this))", new Object[]{EndpointDiscoveryRefreshCache.class, this.poetExtensions.getClientClass(this.model.getNamingStrategy().getServiceName() + "EndpointDiscoveryCacheLoader")});
            builder.endControlFlow();
        }
        return builder.build();
    }

    private List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().filter(o -> !o.hasEventStreamInput()).filter(o -> !o.hasEventStreamOutput()).map(this::operationMethodSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MethodSpec> operationMethodSpecs(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        MethodSpec.Builder method = SyncClientInterface.operationMethodSignature(this.model, opModel).addAnnotation(Override.class).addCode(ClientClassUtils.callApplySignerOverrideMethod(opModel)).addCode(ClientClassUtils.addEndpointTraitCode(opModel)).addCode(this.protocolSpec.responseHandler(this.model, opModel)).addCode(this.protocolSpec.errorResponseHandler(opModel));
        if (opModel.getEndpointDiscovery() != null) {
            method.addStatement("$T cachedEndpoint = null", new Object[]{URI.class});
            method.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED))", new Object[0]);
            method.addStatement("\n\nString key = clientConfiguration.option($T.CREDENTIALS_PROVIDER).resolveCredentials().accessKeyId()", new Object[]{AwsClientOption.class});
            method.addStatement("EndpointDiscoveryRequest endpointDiscoveryRequest = $T.builder().required($L).defaultEndpoint(clientConfiguration.option($T.ENDPOINT)).build()", new Object[]{EndpointDiscoveryRequest.class, opModel.getInputShape().getEndpointDiscovery().isRequired(), SdkClientOption.class});
            method.addStatement("cachedEndpoint = $L.get(key, endpointDiscoveryRequest)", new Object[]{"endpointDiscoveryCache"});
            method.endControlFlow();
        }
        method.addCode(this.protocolSpec.executionHandler(opModel));
        methods.add(method.build());
        methods.addAll(this.paginatedMethods(opModel));
        return methods;
    }

    private List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> paginatedMethodSpecs = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            paginatedMethodSpecs.add(SyncClientInterface.operationMethodSignature(this.model, opModel, SimpleMethodOverload.PAGINATED, PaginatorUtils.getPaginatedMethodName(opModel.getMethodName())).addAnnotation(Override.class).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addStatement("return new $T(this, applyPaginatorUserAgent($L))", new Object[]{this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName()), opModel.getInput().getVariableName()}).build());
        }
        return paginatedMethodSpecs;
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addStatement("clientHandler.close()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    static ProtocolSpec getProtocolSpecs(PoetExtensions poetExtensions, IntermediateModel model) {
        Protocol protocol = model.getMetadata().getProtocol();
        switch (protocol) {
            case QUERY: {
                return new QueryProtocolSpec(poetExtensions);
            }
            case REST_XML: {
                return new XmlProtocolSpec(model, poetExtensions);
            }
            case EC2: {
                return new Ec2ProtocolSpec(poetExtensions);
            }
            case AWS_JSON: 
            case REST_JSON: 
            case CBOR: 
            case ION: {
                return new JsonProtocolSpec(poetExtensions, model);
            }
            case API_GATEWAY: {
                throw new UnsupportedOperationException("Not yet supported.");
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }
}

