/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.client.EnvironmentTokenSystemSettingsClass;
import software.amazon.awssdk.codegen.poet.client.SdkClientOptions;
import software.amazon.awssdk.codegen.poet.common.UserAgentUtilsSpec;

public class CommonInternalGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams params;

    public CommonInternalGeneratorTasks(GeneratorTaskParams params) {
        super(params);
        this.params = params;
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(this.createClientOptionTask());
        tasks.add(this.createUserAgentTask());
        if (this.params.getModel().getCustomizationConfig().isEnableEnvironmentBearerToken()) {
            tasks.add(this.createEnvironmentTokenSystemSettingTask());
        }
        return tasks;
    }

    private PoetGeneratorTask createClientOptionTask() {
        return new PoetGeneratorTask(this.clientOptionsDir(), this.params.getModel().getFileHeader(), new SdkClientOptions(this.params.getModel()));
    }

    private PoetGeneratorTask createUserAgentTask() {
        return new PoetGeneratorTask(this.clientOptionsDir(), this.params.getModel().getFileHeader(), new UserAgentUtilsSpec(this.params.getModel()));
    }

    private GeneratorTask createEnvironmentTokenSystemSettingTask() {
        return new PoetGeneratorTask(this.clientOptionsDir(), this.params.getModel().getFileHeader(), new EnvironmentTokenSystemSettingsClass(this.params.getModel()));
    }

    private String clientOptionsDir() {
        return this.params.getPathProvider().getClientInternalDirectory();
    }
}

