/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.codegen.model.service.ServiceMetadata;

public final class ProtocolUtils {
    private static final List<String> SUPPORTED_PROTOCOLS = Arrays.asList("smithy-rpc-v2-cbor", "json", "rest-json", "rest-xml", "query", "ec2");

    private ProtocolUtils() {
    }

    public static String resolveProtocol(ServiceMetadata serviceMetadata) {
        List<String> protocols = serviceMetadata.getProtocols();
        String protocol = serviceMetadata.getProtocol();
        if (protocols == null || protocols.isEmpty()) {
            return protocol;
        }
        if ("cbor".equals(protocols.get(0))) {
            return "cbor";
        }
        for (String supportedProtocol : SUPPORTED_PROTOCOLS) {
            if (!protocols.contains(supportedProtocol)) continue;
            return supportedProtocol;
        }
        throw new IllegalArgumentException("The SDK does not support any of provided protocols: " + protocols);
    }
}

