/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Objects;
import software.amazon.awssdk.codegen.model.service.AuthType;

public final class AuthTrait {
    private final AuthType authType;
    private final boolean unsignedPayload;

    private AuthTrait(AuthType authType, boolean unsignedPayload) {
        this.authType = Objects.requireNonNull(authType, "authType must not be null");
        this.unsignedPayload = unsignedPayload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AuthType authType() {
        return this.authType;
    }

    public boolean isUnsignedPayload() {
        return this.unsignedPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthTrait that = (AuthTrait)o;
        return this.unsignedPayload == that.unsignedPayload && this.authType == that.authType;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode((Object)this.authType);
        hashCode = 31 * hashCode + (this.unsignedPayload ? 1 : 0);
        return hashCode;
    }

    public String toString() {
        return "AuthTrait{authType=" + (Object)((Object)this.authType) + ", unsignedPayload=" + this.unsignedPayload + '}';
    }

    public static class Builder {
        private AuthType authType;
        private boolean unsignedPayload = false;

        public Builder authType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder unsignedPayload(boolean unsignedPayload) {
            this.unsignedPayload = unsignedPayload;
            return this;
        }

        public AuthTrait build() {
            return new AuthTrait(this.authType, this.unsignedPayload);
        }
    }
}

