/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.ModelAuthSchemeKnowledgeIndex;

public final class SigV4AuthSchemeCodegenKnowledgeIndex {
    private final Map<List<String>, AuthSchemeCodegenMetadata> operationsToSigv4AuthScheme;

    private SigV4AuthSchemeCodegenKnowledgeIndex(IntermediateModel intermediateModel) {
        this.operationsToSigv4AuthScheme = this.operationsToSigv4AuthScheme(ModelAuthSchemeKnowledgeIndex.of(intermediateModel).operationsToMetadata());
    }

    public static SigV4AuthSchemeCodegenKnowledgeIndex of(IntermediateModel intermediateModel) {
        return new SigV4AuthSchemeCodegenKnowledgeIndex(intermediateModel);
    }

    public AuthSchemeCodegenMetadata serviceSigV4Overrides() {
        return this.operationsToSigv4AuthScheme.get(Collections.emptyList());
    }

    public boolean hasPerOperationSigV4Overrides() {
        if (this.operationsToSigv4AuthScheme.containsKey(Collections.emptyList())) {
            return this.operationsToSigv4AuthScheme.size() > 1;
        }
        return !this.operationsToSigv4AuthScheme.isEmpty();
    }

    public boolean hasServiceSigV4Overrides() {
        return this.serviceSigV4Overrides() != null;
    }

    public boolean hasSigV4Overrides() {
        return this.hasServiceSigV4Overrides() || this.hasPerOperationSigV4Overrides();
    }

    public void forEachOperationsOverridesGroup(BiConsumer<List<String>, AuthSchemeCodegenMetadata> consumer) {
        for (Map.Entry<List<String>, AuthSchemeCodegenMetadata> kvp : this.operationsToSigv4AuthScheme.entrySet()) {
            if (kvp.getKey().isEmpty()) continue;
            consumer.accept(kvp.getKey(), kvp.getValue());
        }
    }

    private Map<List<String>, AuthSchemeCodegenMetadata> operationsToSigv4AuthScheme(Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToMetadata) {
        HashMap<List<String>, AuthSchemeCodegenMetadata> result = new HashMap<List<String>, AuthSchemeCodegenMetadata>();
        for (Map.Entry<List<String>, List<AuthSchemeCodegenMetadata>> kvp : operationsToMetadata.entrySet()) {
            AuthSchemeCodegenMetadata sigv4 = this.sigV4AuthSchemeWithConstantOverrides(kvp.getValue());
            if (sigv4 == null) continue;
            result.put(kvp.getKey(), sigv4);
        }
        return result;
    }

    private AuthSchemeCodegenMetadata sigV4AuthSchemeWithConstantOverrides(List<AuthSchemeCodegenMetadata> authSchemes) {
        AuthSchemeCodegenMetadata sigv4 = this.findSigV4AuthScheme(authSchemes);
        if (sigv4 == null) {
            return null;
        }
        List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> signerPropertiesWithConstantValues = this.filterSignerPropertiesWithConstantValues(sigv4.properties());
        if (signerPropertiesWithConstantValues.isEmpty()) {
            return null;
        }
        return sigv4.toBuilder().properties(signerPropertiesWithConstantValues).build();
    }

    private List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> filterSignerPropertiesWithConstantValues(List<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> properties) {
        ArrayList<AuthSchemeCodegenMetadata.SignerPropertyValueProvider> result = null;
        for (AuthSchemeCodegenMetadata.SignerPropertyValueProvider property : properties) {
            if (!property.isConstant()) continue;
            if (result == null) {
                result = new ArrayList<AuthSchemeCodegenMetadata.SignerPropertyValueProvider>();
            }
            result.add(property);
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private AuthSchemeCodegenMetadata findSigV4AuthScheme(List<AuthSchemeCodegenMetadata> authSchemes) {
        for (AuthSchemeCodegenMetadata metadata : authSchemes) {
            if (!metadata.schemeId().equals("aws.auth#sigv4")) continue;
            return metadata;
        }
        return null;
    }
}

