/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;

public final class NewAndLegacyEventStreamProcessor
implements CodegenCustomizationProcessor {
    private static final Map<String, Set<String>> APPROVED_EVENT_STREAMS;

    @Override
    public void preprocess(ServiceModel serviceModel) {
        String serviceId = serviceModel.getMetadata().getServiceId();
        if (!APPROVED_EVENT_STREAMS.containsKey(serviceId)) {
            return;
        }
        Set<String> approvedStreams = APPROVED_EVENT_STREAMS.get(serviceId);
        serviceModel.getShapes().entrySet().stream().filter(e -> ((Shape)e.getValue()).isEventstream()).forEach(e -> {
            String name = (String)e.getKey();
            if (!approvedStreams.contains(name)) {
                throw NewAndLegacyEventStreamProcessor.unknownStreamError(serviceId, name);
            }
        });
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private static RuntimeException unknownStreamError(String serviceId, String evenstreamName) {
        String msg = String.format("Encountered a new eventstream for service %s: %s. This service contains evenstreams that are code generated using an older style that requires a customization. Please contact the Java SDK maintainers for assistance.", serviceId, evenstreamName);
        return new RuntimeException(msg);
    }

    static {
        HashMap<String, HashSet<String>> approvedEventStreams = new HashMap<String, HashSet<String>>();
        approvedEventStreams.put("Kinesis", new HashSet<String>(Arrays.asList("SubscribeToShardEventStream")));
        approvedEventStreams.put("Transcribe Streaming", new HashSet<String>(Arrays.asList("AudioStream", "TranscriptResultStream", "MedicalTranscriptResultStream", "CallAnalyticsTranscriptResultStream", "MedicalScribeInputStream", "MedicalScribeResultStream")));
        APPROVED_EVENT_STREAMS = Collections.unmodifiableMap(approvedEventStreams);
    }
}

