/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetCollectors;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.utils.ToString;

public class ModelMethodOverrides {
    private final ClassName className;
    private final PoetExtension poetExtensions;

    public ModelMethodOverrides(ClassName className, PoetExtension poetExtensions) {
        this.className = className;
        this.poetExtensions = poetExtensions;
    }

    public MethodSpec equalsBySdkFieldsMethod(ShapeModel shapeModel) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"equalsBySdkFields").returns(Boolean.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]).beginControlFlow("if (this == obj)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (obj == null)", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().beginControlFlow("if (!(obj instanceof $T))", new Object[]{this.className}).addStatement("return false", new Object[0]).endControlFlow();
        if (!shapeModel.getNonStreamingMembers().isEmpty()) {
            methodBuilder.addStatement("$T other = ($T) obj", new Object[]{this.className, this.className});
        }
        List<MemberModel> memberModels = shapeModel.getNonStreamingMembers();
        CodeBlock.Builder memberEqualsStmt = CodeBlock.builder();
        if (memberModels.isEmpty()) {
            memberEqualsStmt.addStatement("return true", new Object[0]);
        } else {
            memberEqualsStmt.add("return ", new Object[0]);
            memberEqualsStmt.add(memberModels.stream().map(m -> {
                String getterName = m.getFluentGetterMethodName();
                CodeBlock.Builder result = CodeBlock.builder();
                if (m.getAutoConstructClassIfExists().isPresent()) {
                    String existenceCheckMethodName = m.getExistenceCheckMethodName();
                    result.add("$1N() == other.$1N() && ", new Object[]{existenceCheckMethodName});
                }
                return result.add("$T.equals($N(), other.$N())", new Object[]{Objects.class, getterName, getterName}).build();
            }).collect(PoetCollectors.toDelimitedCodeBlock("&&")));
            memberEqualsStmt.add(";", new Object[0]);
        }
        return methodBuilder.addCode(memberEqualsStmt.build()).build();
    }

    public MethodSpec equalsMethod(ShapeModel shapeModel) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"equals").returns(Boolean.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]);
        CodeBlock.Builder memberEqualsStmt = CodeBlock.builder();
        memberEqualsStmt.add("return ", new Object[0]);
        if (this.poetExtensions.isRequest(shapeModel) || this.poetExtensions.isResponse(shapeModel)) {
            memberEqualsStmt.add("super.equals(obj) && ", new Object[0]);
        }
        memberEqualsStmt.add("equalsBySdkFields(obj);", new Object[0]);
        return methodBuilder.addCode(memberEqualsStmt.build()).build();
    }

    public MethodSpec toStringMethod(ShapeModel shapeModel) {
        String javadoc = "Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be redacted from this string using a placeholder value. ";
        MethodSpec.Builder toStringMethod = MethodSpec.methodBuilder((String)"toString").returns(String.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]);
        toStringMethod.addCode("return $T.builder($S)", new Object[]{ToString.class, shapeModel.getShapeName()});
        shapeModel.getNonStreamingMembers().forEach(m -> toStringMethod.addCode(".add($S, ", new Object[]{m.getName()}).addCode(this.toStringValue((MemberModel)m)).addCode(")", new Object[0]));
        toStringMethod.addCode(".build();", new Object[0]);
        return toStringMethod.build();
    }

    public CodeBlock toStringValue(MemberModel member) {
        if (member.isSensitive()) {
            return CodeBlock.of((String)"$L() == null ? null : $S", (Object[])new Object[]{member.getFluentGetterMethodName(), "*** Sensitive Data Redacted ***"});
        }
        if (member.getAutoConstructClassIfExists().isPresent()) {
            return CodeBlock.of((String)"$N() ? $N() : null", (Object[])new Object[]{member.getExistenceCheckMethodName(), member.getFluentGetterMethodName()});
        }
        return CodeBlock.of((String)"$L()", (Object[])new Object[]{member.getFluentGetterMethodName()});
    }

    public MethodSpec hashCodeMethod(ShapeModel shapeModel) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"hashCode").returns(Integer.TYPE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("int hashCode = 1", new Object[0]);
        if (this.poetExtensions.isRequest(shapeModel) || this.poetExtensions.isResponse(shapeModel)) {
            methodBuilder.addStatement("hashCode = 31 * hashCode + super.hashCode()", new Object[0]);
        }
        shapeModel.getNonStreamingMembers().forEach(m -> methodBuilder.addCode("hashCode = 31 * hashCode + $T.hashCode(", new Object[]{Objects.class}).addCode(this.hashCodeValue((MemberModel)m)).addCode(");\n", new Object[0]));
        methodBuilder.addStatement("return hashCode", new Object[0]);
        return methodBuilder.build();
    }

    public CodeBlock hashCodeValue(MemberModel member) {
        if (member.getAutoConstructClassIfExists().isPresent()) {
            return CodeBlock.of((String)"$N() ? $N() : null", (Object[])new Object[]{member.getExistenceCheckMethodName(), member.getFluentGetterMethodName()});
        }
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{member.getFluentGetterMethodName()});
    }
}

