/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.config.customization.EndpointAuthSchemeConfig;
import software.amazon.awssdk.codegen.model.config.customization.KeyTypePair;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.RuleModel;
import software.amazon.awssdk.codegen.model.service.EndpointRuleSetModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules2.CodeGeneratorVisitor;
import software.amazon.awssdk.codegen.poet.rules2.CodegenExpressionBuidler;
import software.amazon.awssdk.codegen.poet.rules2.ExpressionParser;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

public class EndpointProviderSpec2
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final Map<String, KeyTypePair> knownEndpointAttributes;
    private final CodegenExpressionBuidler utils;
    private final RuleRuntimeTypeMirror typeMirror;

    public EndpointProviderSpec2(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
        String packageName = intermediateModel.getMetadata().getFullInternalEndpointRulesPackageName();
        this.typeMirror = new RuleRuntimeTypeMirror(packageName);
        EndpointRuleSetModel model = intermediateModel.getEndpointRuleSetModel();
        this.utils = EndpointProviderSpec2.createCodegenRulesUtil(model.getRules(), model.getParameters(), this.typeMirror);
        this.knownEndpointAttributes = EndpointProviderSpec2.knownEndpointAttributes(intermediateModel);
    }

    private static RuleType fromParameterModel(ParameterModel model) {
        switch (model.getType().toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                return RuleRuntimeTypeMirror.BOOLEAN;
            }
            case "string": {
                return RuleRuntimeTypeMirror.STRING;
            }
            case "stringarray": {
                return RuleRuntimeTypeMirror.LIST_OF_STRING;
            }
        }
        throw new IllegalStateException("Cannot find rule type for: " + model.getType());
    }

    private static RuleModel createRootRule(List<RuleModel> rules) {
        RuleModel root = new RuleModel();
        root.setRules(rules);
        root.setType("tree");
        root.setConditions(Collections.emptyList());
        return root;
    }

    private static CodegenExpressionBuidler createCodegenRulesUtil(List<RuleModel> rules, Map<String, ParameterModel> parameters, RuleRuntimeTypeMirror typeMirror) {
        RuleSetExpression root = ExpressionParser.parseRuleSetExpression(EndpointProviderSpec2.createRootRule(rules));
        return CodegenExpressionBuidler.from(root, typeMirror, EndpointProviderSpec2.initSymbolTable(parameters));
    }

    private static SymbolTable initSymbolTable(Map<String, ParameterModel> parameters) {
        SymbolTable.Builder builder = SymbolTable.builder();
        parameters.forEach((k, v) -> {
            builder.putParam((String)k, EndpointProviderSpec2.fromParameterModel(v));
            if (v.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
                builder.regionParamName((String)k);
                builder.putLocal((String)k, RuleRuntimeTypeMirror.STRING);
            }
        });
        return builder.build();
    }

    private static Map<String, KeyTypePair> knownEndpointAttributes(IntermediateModel intermediateModel) {
        Map<String, KeyTypePair> knownEndpointAttributes = null;
        EndpointAuthSchemeConfig config = intermediateModel.getCustomizationConfig().getEndpointAuthSchemeConfig();
        if (config != null) {
            knownEndpointAttributes = config.getEndpointProviderTestKeys();
        }
        if (knownEndpointAttributes == null) {
            knownEndpointAttributes = Collections.emptyMap();
        }
        return knownEndpointAttributes;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)this.endpointRulesSpecUtils.providerInterfaceName()).addAnnotation(SdkInternalApi.class);
        builder.addType(this.codegenLocalState());
        builder.addType(this.codegenLocalStateBuilder());
        builder.addMethod(this.resolveEndpointMethod());
        ArrayList<MethodSpec.Builder> methods = new ArrayList<MethodSpec.Builder>();
        this.createRuleMethod(this.utils.root(), methods);
        for (MethodSpec.Builder methodBuilder : methods) {
            builder.addMethod(methodBuilder.build());
        }
        builder.addMethod(this.equalsMethod());
        builder.addMethod(this.hashCodeMethod());
        return builder.build();
    }

    @Override
    public ClassName className() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.endpointRulesSpecUtils.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    private MethodSpec resolveEndpointMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resolveEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.endpointRulesSpecUtils.resolverReturnType()).addAnnotation(Override.class).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), "params", new Modifier[0]);
        builder.addCode(this.validateRequiredParams());
        builder.beginControlFlow("try", new Object[0]);
        String regionParamName = this.utils.regionParamName();
        if (regionParamName != null) {
            builder.addStatement("$T result = $L(params, new $T(params.$L()))", new Object[]{this.ruleResult(), this.utils.root().ruleId(), ClassName.bestGuess((String)"LocalState"), regionParamName});
        } else {
            builder.addStatement("$T result = $L(params, new $T())", new Object[]{this.ruleResult(), this.utils.root().ruleId(), ClassName.bestGuess((String)"LocalState")});
        }
        builder.beginControlFlow("if (result.canContinue())", new Object[0]).addStatement("throw $T.create($S)", new Object[]{SdkClientException.class, "Rule engine did not reach an error or endpoint result"}).endControlFlow();
        builder.beginControlFlow("if (result.isError())", new Object[0]).addStatement("String errorMsg = result.error()", new Object[0]).beginControlFlow("if (errorMsg.contains(\"Invalid ARN\") && errorMsg.contains(\":s3:::\"))", new Object[0]).addStatement("errorMsg += $S", new Object[]{". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest."}).endControlFlow().addStatement("throw $T.create(errorMsg)", new Object[]{SdkClientException.class}).endControlFlow();
        builder.addStatement("return $T.completedFuture(result.endpoint())", new Object[]{CompletableFuture.class});
        builder.nextControlFlow("catch ($T error)", new Object[]{Exception.class});
        builder.addStatement("return $T.failedFuture(error)", new Object[]{CompletableFutureUtils.class});
        builder.endControlFlow();
        return builder.build();
    }

    private CodeBlock validateRequiredParams() {
        CodeBlock.Builder b = CodeBlock.builder();
        Map<String, ParameterModel> parameters = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        parameters.entrySet().stream().filter(e -> Boolean.TRUE.equals(((ParameterModel)e.getValue()).isRequired())).forEach(e -> b.addStatement("$T.notNull($N.$N(), $S)", new Object[]{Validate.class, "params", this.endpointRulesSpecUtils.paramMethodName((String)e.getKey()), String.format("Parameter '%s' must not be null", e.getKey())}));
        return b.build();
    }

    private void createRuleMethod(RuleSetExpression expr, List<MethodSpec.Builder> methods) {
        MethodSpec.Builder builder = this.methodBuilderForRule(expr);
        methods.add(builder);
        CodeBlock.Builder block = CodeBlock.builder();
        this.codegenExpr(expr, block);
        builder.addCode(block.build());
        if (expr.isTree()) {
            for (RuleSetExpression child : expr.children()) {
                this.createRuleMethod(child, methods);
            }
        }
    }

    private MethodSpec.Builder methodBuilderForRule(RuleSetExpression expr) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)expr.ruleId()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(this.ruleResult()).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), "params", new Modifier[0]);
        builder.addParameter((TypeName)ClassName.bestGuess((String)"LocalState"), "locals", new Modifier[0]);
        return builder;
    }

    private void codegenExpr(RuleExpression expr, CodeBlock.Builder builder) {
        CodeGeneratorVisitor visitor = new CodeGeneratorVisitor(this.typeMirror, this.utils.symbolTable(), this.knownEndpointAttributes, builder);
        expr.accept(visitor);
    }

    private TypeSpec codegenLocalState() {
        TypeSpec.Builder b = TypeSpec.classBuilder((String)"LocalState").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        Map<String, RuleType> locals = this.utils.locals();
        locals.forEach((k, v) -> b.addField(v.javaType(), k, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}));
        MethodSpec.Builder emptyCtor = MethodSpec.constructorBuilder();
        locals.forEach((k, v) -> emptyCtor.addStatement("this.$1L = null", new Object[]{k}));
        b.addMethod(emptyCtor.build());
        String regionParamName = this.utils.regionParamName();
        if (regionParamName != null) {
            MethodSpec.Builder regionCtor = MethodSpec.constructorBuilder().addParameter(Region.class, "region", new Modifier[0]);
            locals.forEach((k, v) -> {
                if (k.equals(regionParamName)) {
                    regionCtor.beginControlFlow("if (region != null)", new Object[0]).addStatement("this.$L = region.id()", new Object[]{regionParamName}).nextControlFlow("else", new Object[0]).addStatement("this.$L = null", new Object[]{regionParamName}).endControlFlow();
                } else {
                    regionCtor.addStatement("this.$1L = null", new Object[]{k});
                }
            });
            b.addMethod(regionCtor.build());
        }
        ClassName localStateBuilder = ClassName.bestGuess((String)"LocalStateBuilder");
        MethodSpec.Builder builderCtor = MethodSpec.constructorBuilder().addParameter((TypeName)localStateBuilder, "builder", new Modifier[0]);
        locals.forEach((k, v) -> builderCtor.addStatement("this.$1L = builder.$1L", new Object[]{k}));
        b.addMethod(builderCtor.build());
        locals.forEach((k, v) -> b.addMethod(MethodSpec.methodBuilder((String)k).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(v.javaType()).addStatement("return this.$L", new Object[]{k}).build()));
        b.addMethod(MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)localStateBuilder).addStatement("return new $T(this)", new Object[]{localStateBuilder}).build());
        return b.build();
    }

    private TypeSpec codegenLocalStateBuilder() {
        ClassName localStateClass = ClassName.bestGuess((String)"LocalState");
        ClassName builderClass = ClassName.bestGuess((String)"LocalStateBuilder");
        TypeSpec.Builder b = TypeSpec.classBuilder((String)"LocalStateBuilder").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        Map<String, RuleType> locals = this.utils.locals();
        locals.forEach((k, v) -> b.addField(v.javaType(), k, new Modifier[]{Modifier.PRIVATE}));
        MethodSpec.Builder emptyCtor = MethodSpec.constructorBuilder();
        locals.forEach((k, v) -> emptyCtor.addStatement("this.$1L = null", new Object[]{k}));
        b.addMethod(emptyCtor.build());
        MethodSpec.Builder stateCtor = MethodSpec.constructorBuilder().addParameter((TypeName)localStateClass, "locals", new Modifier[0]);
        locals.forEach((k, v) -> stateCtor.addStatement("this.$1L = locals.$1L", new Object[]{k}));
        b.addMethod(stateCtor.build());
        locals.forEach((k, v) -> b.addMethod(MethodSpec.methodBuilder((String)k).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderClass).addParameter(v.javaType(), "value", new Modifier[0]).addStatement("this.$L = value", new Object[]{k}).addStatement("return this", new Object[0]).build()));
        b.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)localStateClass).addStatement("return new $T(this)", new Object[]{localStateClass}).build());
        return b.build();
    }

    private TypeName ruleResult() {
        return this.typeMirror.rulesResult().type();
    }

    private MethodSpec equalsMethod() {
        return MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "rhs", new Modifier[0]).addStatement("return rhs != null && getClass().equals(rhs.getClass())", new Object[0]).build();
    }

    private MethodSpec hashCodeMethod() {
        return MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return getClass().hashCode()", new Object[0]).build();
    }
}

