/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class FunctionCallExpression
implements RuleExpression {
    private final RuleType type;
    private final String name;
    private final List<RuleExpression> arguments;

    FunctionCallExpression(Builder builder) {
        this.type = builder.type;
        this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
        this.arguments = Collections.unmodifiableList(new ArrayList((Collection)Validate.paramNotNull((Object)builder.arguments, (String)"arguments")));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.FUNCTION_CALL;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        if (this.type == null) {
            buf.append("^UNRESOLVED ");
        } else {
            buf.append("^").append(this.type).append(" ");
        }
        buf.append("(").append(this.name);
        for (RuleExpression arg : this.arguments) {
            buf.append(" ");
            arg.appendTo(buf);
        }
        buf.append(")");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitFunctionCallExpression(this);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public String name() {
        return this.name;
    }

    public List<RuleExpression> arguments() {
        return this.arguments;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCallExpression that = (FunctionCallExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public static class Builder {
        private final List<RuleExpression> arguments = new ArrayList<RuleExpression>();
        private RuleType type;
        private String name;

        public Builder() {
        }

        public Builder(FunctionCallExpression expr) {
            this.type = expr.type;
            this.name = expr.name;
            this.arguments.addAll(expr.arguments);
        }

        public Builder type(RuleType type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addArgument(RuleExpression arg) {
            this.arguments.add(arg);
            return this;
        }

        public Builder arguments(List<RuleExpression> args) {
            this.arguments.clear();
            this.arguments.addAll(args);
            return this;
        }

        public FunctionCallExpression build() {
            return new FunctionCallExpression(this);
        }
    }
}

