/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.rules2.BooleanAndExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.IndexedAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.RewriteRuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleFunctionMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.codegen.poet.rules2.SymbolTable;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.utils.ToString;

public final class AssignTypesVisitor
extends RewriteRuleExpressionVisitor {
    private final RuleRuntimeTypeMirror typeMirror;
    private final SymbolTable.Builder tableBuilder;
    private final List<String> errors;

    public AssignTypesVisitor(RuleRuntimeTypeMirror typeMirror, SymbolTable table) {
        this.typeMirror = typeMirror;
        this.tableBuilder = table.toBuilder();
        this.errors = new ArrayList<String>();
    }

    public Map<String, RuleType> params() {
        return this.tableBuilder.build().params();
    }

    public SymbolTable symbolTable() {
        return this.tableBuilder.build();
    }

    public String toString() {
        return ToString.builder((String)"AssignTypesVisitor").add("typeMirror", (Object)this.typeMirror).add("tableBuilder", (Object)this.tableBuilder).add("errors", this.errors).build();
    }

    public List<String> errors() {
        return this.errors;
    }

    @Override
    public RuleExpression visitVariableReferenceExpression(VariableReferenceExpression e) {
        String variableName = e.variableName();
        RuleType type = this.tableBuilder.local(variableName);
        if (type == null) {
            type = this.tableBuilder.param(variableName);
        }
        if (type == null) {
            return e;
        }
        return e.toBuilder().type(type).build();
    }

    @Override
    public RuleExpression visitFunctionCallExpression(FunctionCallExpression e) {
        FunctionCallExpression expr = (FunctionCallExpression)super.visitFunctionCallExpression(e);
        String name = expr.name();
        RuleFunctionMirror function = this.typeMirror.resolveFunction(name);
        if (function == null) {
            if ("isSet".equals(name)) {
                if (expr.arguments().size() != 1) {
                    this.addError("Function `isSet` expects one argument, got `%s`", expr.arguments());
                } else {
                    expr = expr.toBuilder().type(RuleRuntimeTypeMirror.BOOLEAN).build();
                }
            } else {
                this.addError("Function `%s` not found", name);
            }
            return expr;
        }
        return expr.toBuilder().type(function.returns()).build();
    }

    @Override
    public RuleExpression visitBooleanAndExpression(BooleanAndExpression e) {
        e = (BooleanAndExpression)super.visitBooleanAndExpression(e);
        BooleanAndExpression.Builder builder = BooleanAndExpression.builder();
        for (RuleExpression child : e.expressions()) {
            RuleType childType = child.type();
            if (RuleRuntimeTypeMirror.BOOLEAN.equals(childType)) {
                builder.addExpression(child);
                continue;
            }
            if (childType == null) {
                this.addError("Type for expression `%s` is undefined", child);
                continue;
            }
            builder.addExpression(FunctionCallExpression.builder().type(RuleRuntimeTypeMirror.BOOLEAN).name("isSet").addArgument(child).build());
        }
        return builder.build();
    }

    @Override
    public RuleExpression visitLetExpression(LetExpression e) {
        LetExpression expr = (LetExpression)super.visitLetExpression(e);
        expr.bindings().forEach((k, v) -> {
            RuleType type = v.type();
            if (type == null) {
                this.addError("Cannot find type for variable `%s`, expression: `%s`", k, v);
            } else {
                this.putLocal((String)k, type);
            }
        });
        return expr;
    }

    @Override
    public RuleExpression visitIndexedAccessExpression(IndexedAccessExpression e) {
        IndexedAccessExpression expr = (IndexedAccessExpression)super.visitIndexedAccessExpression(e);
        RuleType sourceType = expr.source().type();
        if (sourceType == null) {
            this.addError("Cannot find type for expression `%s`", expr.source());
        } else if (!sourceType.isList()) {
            this.addError("Expected list type for indexed access expression, got instead `%s`", sourceType);
        } else {
            RuleType type = sourceType.ruleTypeParam();
            expr = expr.toBuilder().type(type).build();
        }
        return expr;
    }

    @Override
    public RuleExpression visitMemberAccessExpression(MemberAccessExpression e) {
        MemberAccessExpression expr = (MemberAccessExpression)super.visitMemberAccessExpression(e);
        RuleType type = expr.source().type();
        if (type == null) {
            this.addError("Cannot find type for expression `%s`", expr.source());
        } else {
            String name = expr.name();
            RuleType memberType = expr.directIndex() ? type : type.property(name);
            if (memberType == null) {
                this.addError("Cannot find a member with name `%s` for type `%s`", name, type);
            } else {
                expr = expr.toBuilder().type(memberType).build();
            }
        }
        return expr;
    }

    private void addError(String fmt, Object ... args) {
        this.errors.add(String.format(fmt, args));
    }

    private void putLocal(String k, RuleType type) {
        RuleType prev = this.tableBuilder.local(k);
        if (prev == null) {
            this.tableBuilder.putLocal(k, type);
        } else if (!prev.equals(type)) {
            this.addError("Local variable `%s` changed type, prev `%s`, new `%s`", k, prev, type);
        }
    }
}

