/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.utils.IoUtils;

public final class JmesPathRuntimeGeneratorTask
extends BaseGeneratorTasks {
    public static final String RUNTIME_CLASS_NAME = "JmesPathRuntime";
    private final String runtimeClassDir;
    private final String runtimePackageName;
    private final String fileHeader;
    private final String runtimeClassCode;

    public JmesPathRuntimeGeneratorTask(GeneratorTaskParams generatorTaskParams) {
        super(generatorTaskParams);
        this.runtimeClassDir = generatorTaskParams.getPathProvider().getJmesPathInternalDirectory();
        this.runtimePackageName = generatorTaskParams.getModel().getMetadata().getFullInternalJmesPathPackageName();
        this.fileHeader = generatorTaskParams.getModel().getFileHeader();
        this.runtimeClassCode = JmesPathRuntimeGeneratorTask.loadRuntimeCode();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        String codeContents = "package " + this.runtimePackageName + ";\n\n" + this.runtimeClassCode;
        String fileName = "JmesPathRuntime.java";
        return Collections.singletonList(new SimpleGeneratorTask(this.runtimeClassDir, fileName, this.fileHeader, () -> codeContents));
    }

    private static String loadRuntimeCode() {
        try {
            InputStream is = JmesPathRuntimeGeneratorTask.class.getResourceAsStream(String.format("/software/amazon/awssdk/codegen/jmespath/%s.java.resource", RUNTIME_CLASS_NAME));
            return IoUtils.toUtf8String((InputStream)is);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

