/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import java.util.Arrays;
import software.amazon.awssdk.utils.StringUtils;

public enum AuthType {
    NONE("none"),
    CUSTOM("custom"),
    IAM("iam"),
    V4("v4"),
    V4_UNSIGNED_BODY("v4-unsigned-body"),
    S3("s3"),
    S3V4("s3v4"),
    BEARER("bearer");

    private final String value;

    private AuthType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static AuthType fromValue(String value) {
        switch (value) {
            case "smithy.api#httpBearerAuth": {
                return BEARER;
            }
            case "smithy.api#noAuth": {
                return NONE;
            }
            case "aws.auth#sigv4": {
                return V4;
            }
        }
        String normalizedValue = StringUtils.lowerCase((String)value);
        return Arrays.stream(AuthType.values()).filter(authType -> authType.value.equals(normalizedValue)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown AuthType '%s'", normalizedValue)));
    }
}

