/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.Http;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.utils.StringUtils;

public class SmithyRpcV2CborProtocolProcessor
implements CodegenCustomizationProcessor {
    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (!"smithy-rpc-v2-cbor".equals(serviceModel.getMetadata().getProtocol())) {
            return;
        }
        serviceModel.getOperations().forEach((name, op) -> this.setRequestUri(serviceModel, (String)name, (Operation)op));
    }

    private void setRequestUri(ServiceModel service, String name, Operation op) {
        Http http = op.getHttp();
        String requestUri = http.getRequestUri();
        if (StringUtils.isNotBlank((CharSequence)requestUri) && !"/".equals(requestUri)) {
            return;
        }
        String uri = String.format("/service/%s/operation/%s", service.getMetadata().getTargetPrefix(), op.getName());
        op.getHttp().setRequestUri(uri);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }
}

