/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.codegen.model.config.customization.EndpointAuthSchemeConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.RuleSetCreationSpec;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public class EndpointProviderSpec
implements ClassSpec {
    private static final String RULE_SET_FIELD_NAME = "ENDPOINT_RULE_SET";
    private static final String LOGGER_FIELD_NAME = "LOG";
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointProviderSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        FieldSpec endpointAuthSchemeStrategyFieldSpec = this.endpointAuthSchemeStrategyFieldSpec();
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)this.endpointRulesSpecUtils.providerInterfaceName()).addField(this.logger()).addField(this.ruleSet()).addField(endpointAuthSchemeStrategyFieldSpec).addMethod(this.resolveEndpointMethod()).addMethod(this.toIdentifierValueMap()).addAnnotation(SdkInternalApi.class);
        MethodSpec constructorMethod = this.constructorMethodSpec(endpointAuthSchemeStrategyFieldSpec.name);
        MethodSpec valueAsEndpointOrThrowMethod = this.valueAsEndpointOrThrowMethodSpec();
        b.addMethod(constructorMethod);
        b.addMethod(valueAsEndpointOrThrowMethod);
        b.addMethod(this.ruleSetBuildMethod(b));
        b.addMethod(this.equalsMethod());
        b.addMethod(this.hashCodeMethod());
        this.addKnownPropertiesMethodSpec(b, endpointAuthSchemeStrategyFieldSpec.name);
        return b.build();
    }

    private FieldSpec endpointAuthSchemeStrategyFieldSpec() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategy"), (String)"endpointAuthSchemeStrategy", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private MethodSpec constructorMethodSpec(String endpointAuthSchemeFieldName) {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        EndpointAuthSchemeConfig endpointAuthSchemeConfig = this.intermediateModel.getCustomizationConfig().getEndpointAuthSchemeConfig();
        String factoryLocalVarName = "endpointAuthSchemeStrategyFactory";
        if (endpointAuthSchemeConfig != null && endpointAuthSchemeConfig.getAuthSchemeStrategyFactoryClass() != null) {
            String endpointAuthSchemeStrategyFactory = endpointAuthSchemeConfig.getAuthSchemeStrategyFactoryClass();
            b.addStatement("$T $N = new $T()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategyFactory"), factoryLocalVarName, PoetUtils.classNameFromFqcn(endpointAuthSchemeStrategyFactory)});
        } else {
            b.addStatement("$T $N = new $T()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategyFactory"), factoryLocalVarName, this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultEndpointAuthSchemeStrategyFactory")});
        }
        b.addStatement("this.$N = $N.endpointAuthSchemeStrategy()", new Object[]{endpointAuthSchemeFieldName, factoryLocalVarName});
        return b.build();
    }

    private MethodSpec valueAsEndpointOrThrowMethodSpec() {
        String valueParamName = "value";
        ParameterSpec param = ParameterSpec.builder((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("Value"), (String)valueParamName, (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"valueAsEndpointOrThrow").returns((TypeName)ClassName.get(Endpoint.class)).addParameter(param);
        CodeBlock.Builder methodCode = CodeBlock.builder().beginControlFlow("if ($N instanceof $T)", new Object[]{valueParamName, this.endpointRulesSpecUtils.rulesRuntimeClassName("Value.Endpoint")}).addStatement("$T endpoint = $N.expectEndpoint()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Value.Endpoint"), valueParamName}).addStatement("$T builder = Endpoint.builder()", new Object[]{Endpoint.Builder.class}).addStatement("builder.url($T.create(endpoint.getUrl()))", new Object[]{URI.class}).addStatement("$T headers = endpoint.getHeaders()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})})}).beginControlFlow("if (headers != null)", new Object[0]).addStatement("headers.forEach((name, values) -> values.forEach(v -> builder.putHeader(name, v)))", new Object[0]).endControlFlow().addStatement("addKnownProperties(builder, endpoint.getProperties())", new Object[0]).addStatement("return builder.build()", new Object[0]).nextControlFlow("else if ($N instanceof $T)", new Object[]{valueParamName, this.endpointRulesSpecUtils.rulesRuntimeClassName("Value.Str")}).addStatement("$T errorMsg = $N.expectString()", new Object[]{String.class, valueParamName}).beginControlFlow("if (errorMsg.contains($S) && errorMsg.contains($S))", new Object[]{"Invalid ARN", ":s3:::"}).addStatement("errorMsg += $S", new Object[]{". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest."}).endControlFlow().addStatement("throw $T.create(errorMsg)", new Object[]{SdkClientException.class}).nextControlFlow("else", new Object[0]).addStatement("throw SdkClientException.create($S + $N)", new Object[]{"Rule engine return neither an endpoint result or error value. Returned value was: ", valueParamName}).endControlFlow();
        b.addCode(methodCode.build());
        return b.build();
    }

    private void addKnownPropertiesMethodSpec(TypeSpec.Builder b, String endpointAuthSpecStrategyFieldName) {
        EndpointAuthSchemeConfig endpointAuthSchemeConfig = this.intermediateModel.getCustomizationConfig().getEndpointAuthSchemeConfig();
        if (endpointAuthSchemeConfig != null && endpointAuthSchemeConfig.getKnownEndpointProperties() != null) {
            this.addKnownEndpointPropertiesMethodOverride(b, endpointAuthSchemeConfig.getKnownEndpointProperties());
        } else {
            b.addMethod(this.defaultAddKnownEndpointPropertyMethod(endpointAuthSpecStrategyFieldName));
        }
    }

    private MethodSpec defaultAddKnownEndpointPropertyMethod(String endpointAuthSpecStrategyFieldName) {
        String builderParamName = "builder";
        String propertiesParamName = "properties";
        MethodSpec.Builder b = this.addKnowPropertiesSignature(builderParamName, propertiesParamName);
        CodeBlock.Builder switchStatementCode = CodeBlock.builder();
        switchStatementCode.beginControlFlow("switch (n)", new Object[0]).add("case $S:\n", new Object[]{"authSchemes"}).indent().add(CodeBlock.builder().addStatement("$N.putAttribute($T.AUTH_SCHEMES, $N.createAuthSchemes(v))", new Object[]{builderParamName, AwsEndpointAttribute.class, endpointAuthSpecStrategyFieldName}).build()).addStatement("break", new Object[0]).add("default:\n", new Object[0]).indent().add(CodeBlock.builder().addStatement("$N.debug(() -> $S + n)", new Object[]{LOGGER_FIELD_NAME, "Ignoring unknown endpoint property: "}).build()).addStatement("break", new Object[0]).endControlFlow();
        CodeBlock.Builder methodCode = CodeBlock.builder();
        CodeBlock lambda = CodeBlock.builder().add("(n, v) -> {\n", new Object[0]).indent().add(switchStatementCode.build()).unindent().add("}", new Object[0]).build();
        methodCode.add("$N.forEach($L);", new Object[]{propertiesParamName, lambda});
        b.addCode(methodCode.build());
        return b.build();
    }

    private MethodSpec equalsMethod() {
        return MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "rhs", new Modifier[0]).addStatement("return rhs != null && getClass().equals(rhs.getClass())", new Object[0]).build();
    }

    private MethodSpec hashCodeMethod() {
        return MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return getClass().hashCode()", new Object[0]).build();
    }

    private void addKnownEndpointPropertiesMethodOverride(TypeSpec.Builder b, String knowPropertyExpression) {
        MethodSpec singlePropertyMethod = MethodSpec.methodBuilder((String)"addKnownProperty").addModifiers(new Modifier[]{Modifier.PRIVATE}).addTypeVariable(TypeVariableName.get((String)"T")).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAttributeProvider"), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), (String)"provider", (Modifier[])new Modifier[0]).build()).addParameter(Endpoint.Builder.class, "builder", new Modifier[0]).addParameter((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("Value"), "value", new Modifier[0]).addStatement("builder.putAttribute(provider.attributeKey(), provider.attributeValue(value))", new Object[0]).build();
        b.addMethod(singlePropertyMethod);
        String builderParamName = "builder";
        String propertiesParamName = "properties";
        MethodSpec.Builder methodBuilder = this.addKnowPropertiesSignature(builderParamName, propertiesParamName);
        ParameterizedTypeName wildcardEndpointAttrType = ParameterizedTypeName.get((ClassName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAttributeProvider"), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        methodBuilder.addStatement("$T knownProperties = $N", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{wildcardEndpointAttrType}), knowPropertyExpression});
        methodBuilder.beginControlFlow("for ($T p: knownProperties)", new Object[]{wildcardEndpointAttrType});
        methodBuilder.beginControlFlow("if ($N.containsKey(p.propertyName()))", new Object[]{propertiesParamName});
        methodBuilder.addStatement("$N(p, $N, $N.get(p.propertyName()))", new Object[]{singlePropertyMethod.name, builderParamName, propertiesParamName});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        b.addMethod(methodBuilder.build());
    }

    private MethodSpec.Builder addKnowPropertiesSignature(String builderParamName, String propertiesParamName) {
        ParameterSpec builderParam = ParameterSpec.builder((TypeName)ClassName.get(Endpoint.Builder.class), (String)builderParamName, (Modifier[])new Modifier[0]).build();
        ParameterSpec propertiesParam = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.endpointRulesSpecUtils.rulesRuntimeClassName("Value")}), (String)propertiesParamName, (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"addKnownProperties").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(builderParam).addParameter(propertiesParam);
    }

    @Override
    public ClassName className() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.endpointRulesSpecUtils.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    private FieldSpec logger() {
        return FieldSpec.builder(Logger.class, (String)LOGGER_FIELD_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.loggerFor($T.class)", new Object[]{Logger.class, this.className()}).build();
    }

    private FieldSpec ruleSet() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointRuleset"), (String)RULE_SET_FIELD_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("ruleSet()", new Object[0]).build();
    }

    private MethodSpec toIdentifierValueMap() {
        ParameterizedTypeName resultType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), this.endpointRulesSpecUtils.rulesRuntimeClassName("Value")});
        String paramsName = "params";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"toIdentifierValueMap").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), paramsName, new Modifier[0]).returns((TypeName)resultType);
        Map<String, ParameterModel> params = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        String resultName = "paramsMap";
        b.addStatement("$T $N = new $T<>()", new Object[]{resultType, resultName, HashMap.class});
        params.forEach((name, model) -> {
            String methodVarName = this.endpointRulesSpecUtils.paramMethodName((String)name);
            CodeBlock identifierExpr = CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), name});
            CodeBlock coerce = model.getBuiltInEnum() == BuiltInParameter.AWS_REGION ? CodeBlock.builder().add(".id()", new Object[0]).build() : CodeBlock.builder().build();
            CodeBlock valueExpr = this.endpointRulesSpecUtils.valueCreationCode(model.getType(), CodeBlock.builder().add("$N.$N()$L", new Object[]{paramsName, methodVarName, coerce}).build());
            b.beginControlFlow("if ($N.$N() != null)", new Object[]{paramsName, methodVarName});
            b.addStatement("$N.put($L, $L)", new Object[]{resultName, identifierExpr, valueExpr});
            b.endControlFlow();
        });
        b.addStatement("return $N", new Object[]{resultName});
        return b.build();
    }

    private MethodSpec resolveEndpointMethod() {
        String paramsName = "endpointParams";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.endpointRulesSpecUtils.resolverReturnType()).addAnnotation(Override.class).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), paramsName, new Modifier[0]);
        b.addCode(this.validateRequiredParams());
        b.addStatement("$T res = new $T().evaluate($N, toIdentifierValueMap($N))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Value"), this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultRuleEngine"), RULE_SET_FIELD_NAME, paramsName});
        b.beginControlFlow("try", new Object[0]);
        b.addStatement("return $T.completedFuture(valueAsEndpointOrThrow($N))", new Object[]{CompletableFuture.class, "res"});
        b.endControlFlow();
        b.beginControlFlow("catch ($T error)", new Object[]{Exception.class});
        b.addStatement("return $T.failedFuture(error)", new Object[]{CompletableFutureUtils.class});
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec ruleSetBuildMethod(TypeSpec.Builder classBuilder) {
        RuleSetCreationSpec ruleSetCreationSpec = new RuleSetCreationSpec(this.intermediateModel);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"ruleSet").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointRuleset")).addStatement("return $L", new Object[]{ruleSetCreationSpec.ruleSetCreationExpr()});
        ruleSetCreationSpec.helperMethods().forEach(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        return b.build();
    }

    private CodeBlock validateRequiredParams() {
        CodeBlock.Builder b = CodeBlock.builder();
        Map<String, ParameterModel> parameters = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        parameters.entrySet().stream().filter(e -> Boolean.TRUE.equals(((ParameterModel)e.getValue()).isRequired())).forEach(e -> b.addStatement("$T.notNull($N.$N(), $S)", new Object[]{Validate.class, "endpointParams", this.endpointRulesSpecUtils.paramMethodName((String)e.getKey()), String.format("Parameter '%s' must not be null", e.getKey())}));
        return b.build();
    }
}

