/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class LetExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final Map<String, RuleExpression> bindings;

    LetExpression(Builder builder) {
        this.bindings = Collections.unmodifiableMap(new LinkedHashMap(builder.bindings));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.LET;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("(let [");
        boolean isFirst = true;
        for (Map.Entry<String, RuleExpression> kvp : this.bindings.entrySet()) {
            if (!isFirst) {
                buf.append(' ');
            }
            buf.append(kvp.getKey()).append(' ');
            kvp.getValue().appendTo(buf);
            isFirst = false;
        }
        buf.append("] \u22ef )");
        return buf;
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitLetExpression(this);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public Map<String, RuleExpression> bindings() {
        return this.bindings;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LetExpression that = (LetExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.bindings.equals(that.bindings);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.bindings.hashCode();
        return result;
    }

    public static class Builder {
        private final Map<String, RuleExpression> bindings = new LinkedHashMap<String, RuleExpression>();

        public Builder putBinding(String name, RuleExpression value) {
            this.bindings.put((String)Validate.paramNotNull((Object)name, (String)"name"), (RuleExpression)Validate.paramNotNull((Object)value, (String)"value"));
            return this;
        }

        public LetExpression build() {
            return new LetExpression(this);
        }
    }
}

