/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.ModelAuthSchemeKnowledgeIndex;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;

public final class ModelAuthSchemeClassesKnowledgeIndex {
    private final Set<Class<?>> serviceConcreteAuthSchemeClasses;

    private ModelAuthSchemeClassesKnowledgeIndex(IntermediateModel intermediateModel) {
        this.serviceConcreteAuthSchemeClasses = ModelAuthSchemeClassesKnowledgeIndex.getServiceConcreteAuthSchemeClasses(ModelAuthSchemeKnowledgeIndex.of(intermediateModel).operationsToMetadata(), intermediateModel.getCustomizationConfig().isEnableEndpointAuthSchemeParams());
    }

    public static ModelAuthSchemeClassesKnowledgeIndex of(IntermediateModel intermediateModel) {
        return new ModelAuthSchemeClassesKnowledgeIndex(intermediateModel);
    }

    public Set<Class<?>> serviceConcreteAuthSchemeClasses() {
        return this.serviceConcreteAuthSchemeClasses;
    }

    private static Set<Class<?>> getServiceConcreteAuthSchemeClasses(Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToAuthSchemes, boolean useEndpointBasedAuthProvider) {
        Set result = operationsToAuthSchemes.values().stream().flatMap(Collection::stream).map(AuthSchemeCodegenMetadata::authSchemeClass).collect(Collectors.toCollection(() -> new TreeSet<Class>(Comparator.comparing(Class::getSimpleName))));
        if (useEndpointBasedAuthProvider) {
            result.add(AwsV4aAuthScheme.class);
        }
        result.add(NoAuthAuthScheme.class);
        return Collections.unmodifiableSet(result);
    }
}

