/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

public class DefaultPartitionDataProviderSpec
implements ClassSpec {
    private static final String VERSION = "version";
    private static final String PARTITIONS = "partitions";
    private static final String ID = "id";
    private static final String REGION_REGEX = "regionRegex";
    private static final String REGIONS = "regions";
    private static final String OUTPUTS = "outputs";
    private static final String DNS_SUFFIX = "dnsSuffix";
    private static final String DUAL_STACK_DNS_SUFFIX = "dualStackDnsSuffix";
    private static final String SUPPORTS_FIPS = "supportsFIPS";
    private static final String SUPPORTS_DUAL_STACK = "supportsDualStack";
    private static final String IMPLICIT_GLOBAL_REGION = "implicitGlobalRegion";
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final ClassName partitionsClass;
    private final ClassName partitionClass;
    private final ClassName regionOverrideClass;
    private final ClassName outputsClass;

    public DefaultPartitionDataProviderSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.partitionsClass = this.endpointRulesSpecUtils.rulesRuntimeClassName("Partitions");
        this.partitionClass = this.endpointRulesSpecUtils.rulesRuntimeClassName("Partition");
        this.regionOverrideClass = this.endpointRulesSpecUtils.rulesRuntimeClassName("RegionOverride");
        this.outputsClass = this.endpointRulesSpecUtils.rulesRuntimeClassName("Outputs");
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("PartitionDataProvider"));
        builder.addType(this.lazyPartitionsContainer());
        builder.addMethod(this.loadPartitionsMethod());
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultPartitionDataProvider");
    }

    private MethodSpec loadPartitionsMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"loadPartitions").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.partitionsClass);
        builder.addStatement("return LazyPartitionsContainer.PARTITIONS", new Object[0]);
        return builder.build();
    }

    private TypeSpec lazyPartitionsContainer() {
        CodeBlock.Builder builder = CodeBlock.builder();
        JsonNode node = JsonNode.parser().parse(this.readPartitionsJson());
        this.codegenPartitions(builder, node);
        return TypeSpec.classBuilder((String)"LazyPartitionsContainer").addModifiers(new Modifier[]{Modifier.STATIC}).addField(FieldSpec.builder((TypeName)this.partitionsClass, (String)"PARTITIONS", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer(builder.build()).build()).build();
    }

    private String readPartitionsJson() {
        String jsonPath = this.endpointRulesSpecUtils.rulesEngineResourceFiles().stream().filter(e -> e.endsWith("partitions.json.resource")).findFirst().orElseThrow(() -> new RuntimeException("Could not find partitions.json.resource"));
        return this.loadResourceAsString("/" + jsonPath);
    }

    private String loadResourceAsString(String path) {
        try {
            return IoUtils.toUtf8String((InputStream)this.loadResource(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream loadResource(String name) {
        InputStream resourceAsStream = DefaultPartitionDataProviderSpec.class.getResourceAsStream(name);
        Validate.notNull((Object)resourceAsStream, (String)"Failed to load resource from %s", (Object[])new Object[]{name});
        return resourceAsStream;
    }

    private void codegenPartitions(CodeBlock.Builder builder, JsonNode node) {
        JsonNode partitions;
        builder.add("$T.builder()", new Object[]{this.partitionsClass});
        Map objNode = node.asObject();
        JsonNode version = (JsonNode)objNode.get(VERSION);
        if (version != null) {
            builder.add(".version(", new Object[0]);
            builder.add("$S", new Object[]{version.asString()});
            builder.add(")", new Object[0]);
        }
        if ((partitions = (JsonNode)objNode.get(PARTITIONS)) != null) {
            partitions.asArray().forEach(partNode -> {
                builder.add(".addPartition(", new Object[0]);
                this.codegenPartition(builder, (JsonNode)partNode);
                builder.add(")", new Object[0]);
            });
        }
        builder.add(".build()", new Object[0]);
    }

    private void codegenPartition(CodeBlock.Builder builder, JsonNode node) {
        JsonNode outputs;
        JsonNode regions;
        JsonNode regionRegex;
        builder.add("$T.builder()", new Object[]{this.partitionClass});
        Map objNode = node.asObject();
        JsonNode id = (JsonNode)objNode.get(ID);
        if (id != null) {
            builder.add(".id(", new Object[0]);
            builder.add("$S", new Object[]{id.asString()});
            builder.add(")", new Object[0]);
        }
        if ((regionRegex = (JsonNode)objNode.get(REGION_REGEX)) != null) {
            builder.add(".regionRegex(", new Object[0]);
            builder.add("$S", new Object[]{regionRegex.asString()});
            builder.add(")", new Object[0]);
        }
        if ((regions = (JsonNode)objNode.get(REGIONS)) != null) {
            Map regionsObj = regions.asObject();
            regionsObj.forEach((k, v) -> {
                builder.add(".putRegion($S, ", new Object[]{k});
                this.codegenRegionOverride(builder);
                builder.add(")", new Object[0]);
            });
        }
        if ((outputs = (JsonNode)objNode.get(OUTPUTS)) != null) {
            builder.add(".outputs(", new Object[0]);
            this.codegenOutputs(builder, outputs);
            builder.add(")", new Object[0]);
        }
        builder.add(".build()", new Object[0]);
    }

    private void codegenRegionOverride(CodeBlock.Builder builder) {
        builder.add("$T.builder().build()", new Object[]{this.regionOverrideClass});
    }

    private void codegenOutputs(CodeBlock.Builder builder, JsonNode node) {
        JsonNode implicitGlobalRegion;
        JsonNode supportsDualStack;
        JsonNode supportsFips;
        JsonNode dualStackDnsSuffix;
        builder.add("$T.builder()", new Object[]{this.outputsClass});
        Map objNode = node.asObject();
        JsonNode dnsSuffix = (JsonNode)objNode.get(DNS_SUFFIX);
        if (dnsSuffix != null) {
            builder.add(".dnsSuffix(", new Object[0]);
            builder.add("$S", new Object[]{dnsSuffix.asString()});
            builder.add(")", new Object[0]);
        }
        if ((dualStackDnsSuffix = (JsonNode)objNode.get(DUAL_STACK_DNS_SUFFIX)) != null) {
            builder.add(".dualStackDnsSuffix(", new Object[0]);
            builder.add("$S", new Object[]{dualStackDnsSuffix.asString()});
            builder.add(")", new Object[0]);
        }
        if ((supportsFips = (JsonNode)objNode.get(SUPPORTS_FIPS)) != null) {
            builder.add(".supportsFips(", new Object[0]);
            builder.add("$L", new Object[]{supportsFips.asBoolean()});
            builder.add(")", new Object[0]);
        }
        if ((supportsDualStack = (JsonNode)objNode.get(SUPPORTS_DUAL_STACK)) != null) {
            builder.add(".supportsDualStack(", new Object[0]);
            builder.add("$L", new Object[]{supportsDualStack.asBoolean()});
            builder.add(")", new Object[0]);
        }
        if ((implicitGlobalRegion = (JsonNode)objNode.get(IMPLICIT_GLOBAL_REGION)) != null) {
            builder.add(".implicitGlobalRegion(", new Object[0]);
            builder.add("$S", new Object[]{implicitGlobalRegion.asString()});
            builder.add(")", new Object[0]);
        }
        builder.add(".build()", new Object[0]);
    }
}

