/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointTestSuiteModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.model.service.EndpointRuleSetModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.model.service.WaiterDefinition;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.IoUtils;

public final class IntermediateModel {
    private static final String FILE_HEADER = IntermediateModel.loadDefaultFileHeader();
    private Metadata metadata;
    private Map<String, OperationModel> operations;
    private Map<String, ShapeModel> shapes;
    private CustomizationConfig customizationConfig;
    private Optional<OperationModel> endpointOperation;
    private Map<String, PaginatorDefinition> paginators;
    private Map<String, WaiterDefinition> waiters;
    @JsonIgnore
    private EndpointRuleSetModel endpointRuleSetModel;
    @JsonIgnore
    private EndpointTestSuiteModel endpointTestSuiteModel;
    @JsonIgnore
    private NamingStrategy namingStrategy;
    private Map<String, ClientContextParam> clientContextParams;

    public IntermediateModel() {
        this.operations = new HashMap<String, OperationModel>();
        this.shapes = new HashMap<String, ShapeModel>();
        this.endpointOperation = Optional.empty();
        this.paginators = new HashMap<String, PaginatorDefinition>();
        this.waiters = new HashMap<String, WaiterDefinition>();
        this.namingStrategy = null;
    }

    public IntermediateModel(Metadata metadata, Map<String, OperationModel> operations, Map<String, ShapeModel> shapes, CustomizationConfig customizationConfig) {
        this(metadata, operations, shapes, customizationConfig, null, Collections.emptyMap(), null, Collections.emptyMap(), null, null, null);
    }

    public IntermediateModel(Metadata metadata, Map<String, OperationModel> operations, Map<String, ShapeModel> shapes, CustomizationConfig customizationConfig, OperationModel endpointOperation, Map<String, PaginatorDefinition> paginators, NamingStrategy namingStrategy, Map<String, WaiterDefinition> waiters, EndpointRuleSetModel endpointRuleSetModel, EndpointTestSuiteModel endpointTestSuiteModel, Map<String, ClientContextParam> clientContextParams) {
        this.metadata = metadata;
        this.operations = operations;
        this.shapes = shapes;
        this.customizationConfig = customizationConfig;
        this.endpointOperation = Optional.ofNullable(endpointOperation);
        this.paginators = paginators;
        this.namingStrategy = namingStrategy;
        this.waiters = waiters;
        this.endpointRuleSetModel = endpointRuleSetModel;
        this.endpointTestSuiteModel = endpointTestSuiteModel;
        this.clientContextParams = clientContextParams;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Map<String, OperationModel> getOperations() {
        return this.operations;
    }

    public void setOperations(Map<String, OperationModel> operations) {
        this.operations = operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().get(operationName);
    }

    public Map<String, ShapeModel> getShapes() {
        return this.shapes;
    }

    public void setShapes(Map<String, ShapeModel> shapes) {
        this.shapes = shapes;
    }

    public ShapeModel getShapeByNameAndC2jName(String shapeName, String shapeC2jName) {
        for (ShapeModel sm : this.getShapes().values()) {
            if (!shapeName.equals(sm.getShapeName()) || !shapeC2jName.equals(sm.getC2jName())) continue;
            return sm;
        }
        throw new IllegalArgumentException("C2J shape " + shapeC2jName + " with shape name " + shapeName + " does not exist in the intermediate model.");
    }

    public CustomizationConfig getCustomizationConfig() {
        return this.customizationConfig;
    }

    public void setCustomizationConfig(CustomizationConfig customizationConfig) {
        this.customizationConfig = customizationConfig;
    }

    public Map<String, PaginatorDefinition> getPaginators() {
        return this.paginators;
    }

    public Map<String, WaiterDefinition> getWaiters() {
        return this.waiters;
    }

    public EndpointRuleSetModel getEndpointRuleSetModel() {
        if (this.endpointRuleSetModel == null) {
            this.endpointRuleSetModel = EndpointRuleSetModel.defaultRules(this.metadata.getEndpointPrefix());
        }
        return this.endpointRuleSetModel;
    }

    public EndpointTestSuiteModel getEndpointTestSuiteModel() {
        if (this.endpointTestSuiteModel == null) {
            this.endpointTestSuiteModel = new EndpointTestSuiteModel();
        }
        return this.endpointTestSuiteModel;
    }

    public Map<String, ClientContextParam> getClientContextParams() {
        return this.clientContextParams;
    }

    public void setPaginators(Map<String, PaginatorDefinition> paginators) {
        this.paginators = paginators;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public String getCustomRetryPolicy() {
        return this.customizationConfig.getCustomRetryPolicy();
    }

    public String getCustomRetryStrategy() {
        return this.customizationConfig.getCustomRetryStrategy();
    }

    public String getSdkModeledExceptionBaseFqcn() {
        return String.format("%s.%s", this.metadata.getFullModelPackageName(), this.getSdkModeledExceptionBaseClassName());
    }

    public String getSdkModeledExceptionBaseClassName() {
        if (this.customizationConfig.getSdkModeledExceptionBaseClassName() != null) {
            return this.customizationConfig.getSdkModeledExceptionBaseClassName();
        }
        return this.metadata.getBaseExceptionName();
    }

    public String getSdkRequestBaseClassName() {
        if (this.customizationConfig.getSdkRequestBaseClassName() != null) {
            return this.customizationConfig.getSdkRequestBaseClassName();
        }
        return this.metadata.getBaseRequestName();
    }

    public String getSdkResponseBaseClassName() {
        if (this.customizationConfig.getSdkResponseBaseClassName() != null) {
            return this.customizationConfig.getSdkResponseBaseClassName();
        }
        return this.metadata.getBaseResponseName();
    }

    public Optional<String> syncClientDecoratorClassName() {
        if (this.customizationConfig.getSyncClientDecorator() != null) {
            return Optional.of(this.customizationConfig.getSyncClientDecorator());
        }
        return Optional.empty();
    }

    public Optional<String> asyncClientDecoratorClassName() {
        String asyncClientDecorator = this.customizationConfig.getAsyncClientDecorator();
        if (this.customizationConfig.getAsyncClientDecorator() != null) {
            return Optional.of(asyncClientDecorator);
        }
        return Optional.empty();
    }

    public String getFileHeader() {
        return FILE_HEADER;
    }

    private static String loadDefaultFileHeader() {
        String string;
        block8: {
            InputStream inputStream = IntermediateModel.class.getResourceAsStream("/software/amazon/awssdk/codegen/DefaultFileHeader.txt");
            try {
                string = IoUtils.toUtf8String((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public String getSdkBaseResponseFqcn() {
        return String.format("%s<%s>", AwsResponse.class.getName(), this.getResponseMetadataClassName());
    }

    private String getResponseMetadataClassName() {
        return AwsResponseMetadata.class.getName();
    }

    public Optional<OperationModel> getEndpointOperation() {
        return this.endpointOperation;
    }

    public void setEndpointOperation(OperationModel endpointOperation) {
        this.endpointOperation = Optional.ofNullable(endpointOperation);
    }

    public boolean hasPaginators() {
        return this.paginators.size() > 0;
    }

    public boolean hasWaiters() {
        return this.waiters.size() > 0;
    }

    public boolean containsRequestSigners() {
        return this.getShapes().values().stream().anyMatch(ShapeModel::isRequestSignerAware);
    }

    public boolean containsRequestEventStreams() {
        return this.getOperations().values().stream().anyMatch(OperationModel::hasEventStreamInput);
    }
}

