/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadata;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeCodegenMetadataExt;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthTypeToSigV4Default;
import software.amazon.awssdk.codegen.poet.auth.scheme.SigV4SignerDefaults;

public final class ModelAuthSchemeKnowledgeIndex {
    private final IntermediateModel intermediateModel;

    private ModelAuthSchemeKnowledgeIndex(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
    }

    public static ModelAuthSchemeKnowledgeIndex of(IntermediateModel intermediateModel) {
        return new ModelAuthSchemeKnowledgeIndex(intermediateModel);
    }

    public Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToMetadata() {
        List<AuthType> serviceDefaults = this.serviceDefaultAuthTypes();
        if (serviceDefaults.size() == 1) {
            String authTypeName = serviceDefaults.get(0).value();
            SigV4SignerDefaults defaults = AuthTypeToSigV4Default.authTypeToDefaults().get(authTypeName);
            if (this.areServiceWide(defaults)) {
                return this.operationsToModeledMetadataFormSigV4Defaults(defaults);
            }
        }
        return this.operationsToModeledMetadata();
    }

    private Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToModeledMetadata() {
        Map<List<String>, List<AuthType>> operationsToAuthType = this.operationsToAuthType();
        LinkedHashMap<List<String>, List<AuthSchemeCodegenMetadata>> operationsToMetadata = new LinkedHashMap<List<String>, List<AuthSchemeCodegenMetadata>>();
        operationsToAuthType.forEach((k, v) -> operationsToMetadata.put((List<String>)k, this.authTypeToCodegenMetadata((List<AuthType>)v)));
        return operationsToMetadata;
    }

    private Map<List<String>, List<AuthType>> operationsToAuthType() {
        Map authSchemesToOperations = this.intermediateModel.getOperations().entrySet().stream().filter(kvp -> !((OperationModel)kvp.getValue()).getAuth().isEmpty()).collect(Collectors.groupingBy(kvp -> ((OperationModel)kvp.getValue()).getAuth(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        Map operationsToAuthType = authSchemesToOperations.entrySet().stream().sorted(Comparator.comparing(kvp -> (String)((List)kvp.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, LinkedHashMap::new));
        List<AuthType> serviceDefaults = this.serviceDefaultAuthTypes();
        List operationsWithDefaults = authSchemesToOperations.remove(serviceDefaults);
        operationsToAuthType.remove(operationsWithDefaults);
        operationsToAuthType.put(Collections.emptyList(), serviceDefaults);
        return operationsToAuthType;
    }

    private Map<List<String>, List<AuthSchemeCodegenMetadata>> operationsToModeledMetadataFormSigV4Defaults(SigV4SignerDefaults defaults) {
        Map defaultsToOperations = defaults.operations().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        Map operationsToDefaults = defaultsToOperations.entrySet().stream().sorted(Comparator.comparing(left -> (String)((List)left.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, LinkedHashMap::new));
        LinkedHashMap<List<String>, List<AuthSchemeCodegenMetadata>> result = new LinkedHashMap<List<String>, List<AuthSchemeCodegenMetadata>>();
        for (Map.Entry kvp : operationsToDefaults.entrySet()) {
            result.put((List)kvp.getKey(), Arrays.asList(AuthSchemeCodegenMetadataExt.fromConstants((SigV4SignerDefaults)kvp.getValue())));
        }
        result.put(Collections.emptyList(), Arrays.asList(AuthSchemeCodegenMetadataExt.fromConstants(defaults)));
        return result;
    }

    private List<AuthType> serviceDefaultAuthTypes() {
        List<AuthType> modeled = this.intermediateModel.getMetadata().getAuth();
        if (!modeled.isEmpty()) {
            return modeled;
        }
        return Collections.singletonList(this.intermediateModel.getMetadata().getAuthType());
    }

    private List<AuthSchemeCodegenMetadata> authTypeToCodegenMetadata(List<AuthType> authTypes) {
        return authTypes.stream().map(AuthSchemeCodegenMetadataExt::fromAuthType).collect(Collectors.toList());
    }

    private boolean areServiceWide(SigV4SignerDefaults defaults) {
        return defaults != null && defaults.isServiceOverrideAuthScheme() && Objects.equals(this.intermediateModel.getMetadata().getServiceName(), defaults.service());
    }
}

