/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.auth.scheme.SigV4SignerDefaults;
import software.amazon.awssdk.utils.Lazy;

public final class AuthTypeToSigV4Default {
    public static final SigV4SignerDefaults SIGV4_DEFAULT = SigV4SignerDefaults.builder().authType("v4").schemeId("aws.auth#sigv4").build();
    private static final Lazy<Map<String, SigV4SignerDefaults>> AUTH_TYPE_TO_DEFAULTS = new Lazy(() -> {
        LinkedHashMap<String, SigV4SignerDefaults> map = new LinkedHashMap<String, SigV4SignerDefaults>();
        for (SigV4SignerDefaults sigv4FamilySignerConstants : AuthTypeToSigV4Default.knownAuthTypes()) {
            if (map.put(sigv4FamilySignerConstants.authType(), sigv4FamilySignerConstants) == null) continue;
            throw new IllegalStateException("Duplicate key: " + sigv4FamilySignerConstants.authType());
        }
        return map;
    });

    private AuthTypeToSigV4Default() {
    }

    public static Map<String, SigV4SignerDefaults> authTypeToDefaults() {
        return (Map)AUTH_TYPE_TO_DEFAULTS.getValue();
    }

    public static List<SigV4SignerDefaults> knownAuthTypes() {
        return Arrays.asList(AuthTypeToSigV4Default.sigv4Default(), AuthTypeToSigV4Default.s3Defaults(), AuthTypeToSigV4Default.s3v4Defaults(), AuthTypeToSigV4Default.sigv4UnsignedPayload());
    }

    private static SigV4SignerDefaults sigv4Default() {
        return SIGV4_DEFAULT;
    }

    private static SigV4SignerDefaults s3Defaults() {
        return AuthTypeToSigV4Default.sigv4Default().toBuilder().authType("s3").service("S3").doubleUrlEncode(Boolean.FALSE).normalizePath(Boolean.FALSE).payloadSigningEnabled(Boolean.FALSE).putOperation("UploadPart", AuthTypeToSigV4Default.sigv4Default().toBuilder().doubleUrlEncode(Boolean.FALSE).normalizePath(Boolean.FALSE).payloadSigningEnabled(Boolean.FALSE).chunkEncodingEnabled(Boolean.TRUE).build()).putOperation("PutObject", AuthTypeToSigV4Default.sigv4Default().toBuilder().doubleUrlEncode(Boolean.FALSE).normalizePath(Boolean.FALSE).payloadSigningEnabled(Boolean.FALSE).chunkEncodingEnabled(Boolean.TRUE).build()).build();
    }

    private static SigV4SignerDefaults s3v4Defaults() {
        return AuthTypeToSigV4Default.sigv4Default().toBuilder().authType("s3v4").doubleUrlEncode(false).normalizePath(false).build();
    }

    private static SigV4SignerDefaults sigv4UnsignedPayload() {
        return AuthTypeToSigV4Default.sigv4Default().toBuilder().authType("v4-unsigned-body").payloadSigningEnabled(false).build();
    }
}

