/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.checksum.HttpChecksum;
import software.amazon.awssdk.codegen.compression.RequestCompression;
import software.amazon.awssdk.codegen.docs.ClientType;
import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.OperationDocs;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.ArgumentModel;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.EndpointDiscovery;
import software.amazon.awssdk.codegen.model.intermediate.ExceptionModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.SimpleMethodFormModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.EndpointTrait;
import software.amazon.awssdk.codegen.model.service.StaticContextParam;

public class OperationModel
extends DocumentationModel {
    private String operationName;
    private String serviceProtocol;
    private boolean deprecated;
    private String deprecatedMessage;
    private VariableModel input;
    private ReturnTypeModel returnType;
    private List<ExceptionModel> exceptions = new ArrayList<ExceptionModel>();
    private List<SimpleMethodFormModel> simpleMethods;
    private boolean hasBlobMemberAsPayload;
    private boolean hasStringMemberAsPayload;
    private boolean isAuthenticated = true;
    private AuthType authType;
    private List<AuthType> auth;
    private boolean isPaginated;
    private boolean endpointOperation;
    private boolean endpointCacheRequired;
    private EndpointDiscovery endpointDiscovery;
    @JsonIgnore
    private ShapeModel inputShape;
    @JsonIgnore
    private ShapeModel outputShape;
    private EndpointTrait endpointTrait;
    private boolean httpChecksumRequired;
    private HttpChecksum httpChecksum;
    private RequestCompression requestCompression;
    @JsonIgnore
    private Map<String, StaticContextParam> staticContextParams;

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getMethodName() {
        return Utils.unCapitalize(this.operationName);
    }

    public String getServiceProtocol() {
        return this.serviceProtocol;
    }

    public void setServiceProtocol(String serviceProtocol) {
        this.serviceProtocol = serviceProtocol;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecatedMessage() {
        return this.deprecatedMessage;
    }

    public void setDeprecatedMessage(String deprecatedMessage) {
        this.deprecatedMessage = deprecatedMessage;
    }

    public String getDocs(IntermediateModel model, ClientType clientType) {
        return OperationDocs.getDocs(model, this, clientType);
    }

    public String getDocs(IntermediateModel model, ClientType clientType, SimpleMethodOverload methodOverload) {
        return OperationDocs.getDocs(model, this, clientType, methodOverload);
    }

    public String getDocs(IntermediateModel model, ClientType clientType, SimpleMethodOverload methodOverload, DocConfiguration config) {
        return OperationDocs.getDocs(model, this, clientType, methodOverload, config);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public List<AuthType> getAuth() {
        return this.auth;
    }

    public void setAuth(List<AuthType> auth) {
        this.auth = auth;
    }

    public ShapeModel getInputShape() {
        return this.inputShape;
    }

    public void setInputShape(ShapeModel inputShape) {
        this.inputShape = inputShape;
    }

    public ShapeModel getOutputShape() {
        return this.outputShape;
    }

    public void setOutputShape(ShapeModel outputShape) {
        this.outputShape = outputShape;
    }

    public VariableModel getInput() {
        return this.input;
    }

    public void setInput(VariableModel input) {
        this.input = input;
    }

    public ReturnTypeModel getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnTypeModel returnType) {
        this.returnType = returnType;
    }

    public String getSyncReturnType() {
        return this.returnType.getReturnType();
    }

    public List<ExceptionModel> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionModel> exceptions) {
        this.exceptions = exceptions;
    }

    public void addException(ExceptionModel exception) {
        this.exceptions.add(exception);
    }

    @JsonIgnore
    public List<SimpleMethodFormModel> getSimpleMethodForms() {
        return this.simpleMethods;
    }

    public void addSimpleMethodForm(List<ArgumentModel> arguments) {
        if (this.simpleMethods == null) {
            this.simpleMethods = new ArrayList<SimpleMethodFormModel>();
        }
        SimpleMethodFormModel form = new SimpleMethodFormModel();
        form.setArguments(arguments);
        this.simpleMethods.add(form);
    }

    public boolean getHasBlobMemberAsPayload() {
        return this.hasBlobMemberAsPayload;
    }

    public void setHasBlobMemberAsPayload(boolean hasBlobMemberAsPayload) {
        this.hasBlobMemberAsPayload = hasBlobMemberAsPayload;
    }

    public boolean getHasStringMemberAsPayload() {
        return this.hasStringMemberAsPayload;
    }

    public void setHasStringMemberAsPayload(boolean hasStringMemberAsPayload) {
        this.hasStringMemberAsPayload = hasStringMemberAsPayload;
    }

    public boolean hasStreamingInput() {
        return this.inputShape != null && this.inputShape.isHasStreamingMember();
    }

    public boolean hasStreamingOutput() {
        return this.outputShape != null && this.outputShape.isHasStreamingMember();
    }

    @JsonIgnore
    public boolean isStreaming() {
        return this.hasStreamingInput() || this.hasStreamingOutput();
    }

    public boolean isEndpointOperation() {
        return this.endpointOperation;
    }

    public void setEndpointOperation(boolean endpointOperation) {
        this.endpointOperation = endpointOperation;
    }

    public boolean isEndpointCacheRequired() {
        return this.endpointCacheRequired;
    }

    public void setEndpointCacheRequired(boolean endpointCacheRequired) {
        this.endpointCacheRequired = endpointCacheRequired;
    }

    public boolean isPaginated() {
        return this.isPaginated;
    }

    public void setPaginated(boolean paginated) {
        this.isPaginated = paginated;
    }

    public EndpointDiscovery getEndpointDiscovery() {
        return this.endpointDiscovery;
    }

    public void setEndpointDiscovery(EndpointDiscovery endpointDiscovery) {
        this.endpointDiscovery = endpointDiscovery;
    }

    public EndpointTrait getEndpointTrait() {
        return this.endpointTrait;
    }

    public void setEndpointTrait(EndpointTrait endpointTrait) {
        this.endpointTrait = endpointTrait;
    }

    public boolean hasEventStreamOutput() {
        return this.containsEventStream(this.outputShape);
    }

    public boolean hasEventStreamInput() {
        return this.containsEventStream(this.inputShape);
    }

    public boolean hasRequiresLengthInInput() {
        return this.inputShape != null && this.inputShape.isHasRequiresLengthMember();
    }

    private boolean containsEventStream(ShapeModel shapeModel) {
        return shapeModel != null && shapeModel.getMembers() != null && shapeModel.getMembers().stream().filter(m -> m.getShape() != null).anyMatch(m -> m.getShape().isEventStream());
    }

    public boolean isHttpChecksumRequired() {
        return this.httpChecksumRequired;
    }

    public void setHttpChecksumRequired(boolean httpChecksumRequired) {
        this.httpChecksumRequired = httpChecksumRequired;
    }

    public HttpChecksum getHttpChecksum() {
        return this.httpChecksum;
    }

    public void setHttpChecksum(HttpChecksum httpChecksum) {
        this.httpChecksum = httpChecksum;
    }

    public RequestCompression getRequestCompression() {
        return this.requestCompression;
    }

    public void setRequestCompression(RequestCompression requestCompression) {
        this.requestCompression = requestCompression;
    }

    public Map<String, StaticContextParam> getStaticContextParams() {
        return this.staticContextParams;
    }

    public void setStaticContextParams(Map<String, StaticContextParam> staticContextParams) {
        this.staticContextParams = staticContextParams;
    }
}

