/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;
import software.amazon.awssdk.utils.Validate;

public class ServiceClientConfigurationClass
implements ClassSpec {
    private final ClassName defaultClientMetadataClassName;
    private final ServiceClientConfigurationUtils utils;

    public ServiceClientConfigurationClass(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        String serviceId = model.getMetadata().getServiceName();
        this.defaultClientMetadataClassName = ClassName.get((String)basePackage, (String)(serviceId + "ServiceClientConfiguration"), (String[])new String[0]);
        this.utils = new ServiceClientConfigurationUtils(model);
    }

    @Override
    public ClassName className() {
        return this.utils.serviceClientConfigurationClassName();
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.defaultClientMetadataClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkPublicApi.class).superclass(AwsServiceClientConfiguration.class).addJavadoc("Class to expose the service client settings to the user. Implementation of {@link $T}", new Object[]{AwsServiceClientConfiguration.class});
        builder.addMethod(this.constructor());
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            this.addLocalFieldForDataIfNeeded(field, builder);
            if (!field.isLocalField()) continue;
            builder.addMethod(this.getterForDataField(field));
        }
        return builder.addMethod(this.builderMethod()).addType(this.builderInterfaceSpec()).build();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.className().nestedClass("Builder"), "builder", new Modifier[0]);
        builder.addStatement("super(builder)", new Object[0]);
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            if (!field.isLocalField()) continue;
            builder.addStatement("this.$L = builder.$L()", new Object[]{field.name(), field.name()});
        }
        return builder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return $T.builder()", new Object[]{this.utils.serviceClientConfigurationBuilderClassName()}).returns((TypeName)this.className().nestedClass("Builder")).build();
    }

    private TypeSpec builderInterfaceSpec() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(AwsServiceClientConfiguration.class).nestedClass("Builder")).addJavadoc("A builder for creating a {@link $T}", new Object[]{this.className()});
        for (ServiceClientConfigurationUtils.Field field : this.utils.serviceClientConfigurationFields()) {
            builder.addMethod(this.baseSetterForField(field).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build());
            builder.addMethod(this.baseGetterForField(field).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build());
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).build());
        return builder.build();
    }

    private void addLocalFieldForDataIfNeeded(ServiceClientConfigurationUtils.Field field, TypeSpec.Builder builder) {
        if (field.isLocalField()) {
            builder.addField(field.type(), field.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
    }

    private MethodSpec.Builder baseSetterForField(ServiceClientConfigurationUtils.Field field) {
        MethodSpec fieldBuilderSetter = field.builderSetter();
        if (fieldBuilderSetter != null) {
            return fieldBuilderSetter.toBuilder().returns((TypeName)this.className().nestedClass("Builder"));
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)field.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(field.type(), field.name(), new Modifier[0]).addJavadoc("Sets the value for " + field.doc(), new Object[0]).returns((TypeName)this.className().nestedClass("Builder"));
        if (!field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        return builder;
    }

    private MethodSpec getterForDataField(ServiceClientConfigurationUtils.Field field) {
        return this.getterForField(field, "config", true);
    }

    private MethodSpec getterForField(ServiceClientConfigurationUtils.Field field, String fieldName, boolean forDataGetter) {
        MethodSpec fieldBuilderGetter = field.builderGetterImpl();
        if (fieldBuilderGetter != null) {
            return fieldBuilderGetter.toBuilder().returns(field.type()).build();
        }
        MethodSpec.Builder builder = this.baseGetterForField(field);
        if (!forDataGetter && field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        if (forDataGetter && field.isLocalField()) {
            return builder.addStatement("return $L", new Object[]{field.name()}).build();
        }
        if (field.optionClass() == null) {
            return builder.addStatement("return $L", new Object[]{field.name()}).build();
        }
        if (field.baseType() != null) {
            return builder.addStatement("$T result = $L.option($T.$L)", new Object[]{field.baseType(), fieldName, field.optionClass(), field.optionName()}).beginControlFlow("if (result == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $T.isInstanceOf($T.class, result, $S + $T.class.getSimpleName())", new Object[]{Validate.class, field.type(), "Expected an instance of ", field.type()}).build();
        }
        return builder.addStatement("return $L.option($T.$L)", new Object[]{fieldName, field.optionClass(), field.optionName()}).build();
    }

    private MethodSpec.Builder baseGetterForField(ServiceClientConfigurationUtils.Field field) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)field.name()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Gets the value for " + field.doc(), new Object[0]).returns(field.type());
        if (!field.isLocalField()) {
            builder.addAnnotation(Override.class);
        }
        return builder;
    }
}

