/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;

public final class AuthUtils {
    private AuthUtils() {
    }

    public static boolean usesBearerAuth(IntermediateModel model) {
        if (AuthUtils.isServiceBearerAuth(model)) {
            return true;
        }
        return model.getOperations().values().stream().map(OperationModel::getAuthType).anyMatch(authType -> authType == AuthType.BEARER);
    }

    public static boolean usesAwsAuth(IntermediateModel model) {
        if (AuthUtils.isServiceAwsAuthType(model)) {
            return true;
        }
        return model.getOperations().values().stream().map(OperationModel::getAuthType).anyMatch(AuthUtils::isAuthTypeAws);
    }

    public static boolean isOpBearerAuth(IntermediateModel model, OperationModel opModel) {
        if (opModel.getAuthType() == AuthType.BEARER) {
            return true;
        }
        return AuthUtils.isServiceBearerAuth(model) && AuthUtils.hasNoAuthType(opModel);
    }

    private static boolean isServiceBearerAuth(IntermediateModel model) {
        return model.getMetadata().getAuthType() == AuthType.BEARER;
    }

    private static boolean isServiceAwsAuthType(IntermediateModel model) {
        AuthType authType = model.getMetadata().getAuthType();
        return AuthUtils.isAuthTypeAws(authType);
    }

    private static boolean isAuthTypeAws(AuthType authType) {
        if (authType == null) {
            return false;
        }
        switch (authType) {
            case V4: 
            case S3: 
            case S3V4: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasNoAuthType(OperationModel opModel) {
        return opModel.getAuthType() == null || opModel.getAuthType() == AuthType.NONE;
    }
}

