/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ConditionModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterDeprecatedModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.RuleModel;
import software.amazon.awssdk.codegen.model.service.EndpointRuleSetModel;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.utils.MapUtils;

public class RuleSetCreationSpec {
    private static final String RULE_METHOD_PREFIX = "endpointRule_";
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final EndpointRuleSetModel ruleSetModel;
    private int ruleCounter = 0;
    private final List<MethodSpec> helperMethods = new ArrayList<MethodSpec>();

    public RuleSetCreationSpec(IntermediateModel intermediateModel) {
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
        this.ruleSetModel = intermediateModel.getEndpointRuleSetModel();
    }

    public CodeBlock ruleSetCreationExpr() {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointRuleset")}).add(".version($S)", new Object[]{this.ruleSetModel.getVersion()}).add(".serviceId($S)", new Object[]{this.ruleSetModel.getServiceId()}).add(".parameters($L)", new Object[]{this.parameters(this.ruleSetModel.getParameters())});
        this.ruleSetModel.getRules().stream().map(this::rule).forEach(m -> b.add(".addRule($N())", new Object[]{m.name}));
        b.add(".build()", new Object[0]);
        return b.build();
    }

    public List<MethodSpec> helperMethods() {
        return this.helperMethods;
    }

    private CodeBlock parameters(Map<String, ParameterModel> params) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Parameters")});
        params.forEach((name, model) -> b.add(".addParameter($L)", new Object[]{this.parameter((String)name, (ParameterModel)model)}));
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private CodeBlock parameter(String name, ParameterModel model) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Parameter")}).add(".name($S)", new Object[]{name}).add(".type($T.fromValue($S))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("ParameterType"), model.getType()}).add(".required($L)", new Object[]{Boolean.TRUE.equals(model.isRequired())});
        if (model.getBuiltIn() != null) {
            b.add(".builtIn($S)", new Object[]{model.getBuiltIn()});
        }
        if (model.getDocumentation() != null) {
            b.add(".documentation($S)", new Object[]{model.getDocumentation()});
        }
        if (model.getDefault() != null) {
            CodeBlock value;
            TreeNode defaultValue = model.getDefault();
            JsonToken token = defaultValue.asToken();
            if (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE) {
                value = this.endpointRulesSpecUtils.valueCreationCode("boolean", CodeBlock.builder().add("$L", new Object[]{((JrsBoolean)defaultValue).booleanValue()}).build());
            } else if (token == JsonToken.VALUE_STRING) {
                value = this.endpointRulesSpecUtils.valueCreationCode("string", CodeBlock.builder().add("$S", new Object[]{((JrsString)defaultValue).getValue()}).build());
            } else {
                throw new RuntimeException("Can't set default value type " + token.name());
            }
            b.add(".defaultValue($L)", new Object[]{value});
        }
        if (model.getDeprecated() != null) {
            ParameterDeprecatedModel deprecated = model.getDeprecated();
            b.add(".deprecated(new $T($S, $S))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Parameter.Deprecated"), deprecated.getMessage(), deprecated.getSince()});
        }
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private MethodSpec rule(RuleModel model) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.nextRuleMethodName());
        methodBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        methodBuilder.returns((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("Rule"));
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Rule")});
        model.getConditions().forEach(c -> b.add(".addCondition($L)", new Object[]{this.condition((ConditionModel)c)}));
        if ("error".equals(model.getType())) {
            b.add(".error($S)", new Object[]{model.getError()});
        } else if ("tree".equals(model.getType())) {
            CodeBlock.Builder rulesArray = CodeBlock.builder().add("$T.asList(", new Object[]{Arrays.class});
            int nRules = model.getRules().size();
            for (int i = 0; i < nRules; ++i) {
                MethodSpec childRule = this.rule(model.getRules().get(i));
                rulesArray.add("$N()", new Object[]{childRule.name});
                if (i + 1 >= nRules) continue;
                rulesArray.add(", ", new Object[0]);
            }
            rulesArray.add(")", new Object[0]);
            b.add(".treeRule($L)", new Object[]{rulesArray.build()});
        } else if ("endpoint".equals(model.getType())) {
            CodeBlock endpoint = this.endpoint(model.getEndpoint());
            b.add(".endpoint($L)", new Object[]{endpoint});
        }
        MethodSpec m = methodBuilder.addStatement("return $L", new Object[]{b.build()}).build();
        this.helperMethods.add(m);
        return m;
    }

    private CodeBlock endpoint(EndpointModel model) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointResult")});
        TreeNode url = model.getUrl();
        b.add(".url($L)", new Object[]{this.expr(url)});
        if (model.getHeaders() != null) {
            model.getHeaders().forEach((name, valueList) -> valueList.forEach(value -> b.add(".addHeaderValue($S, $L)", new Object[]{name, this.expr((TreeNode)value)})));
        }
        if (model.getProperties() != null) {
            model.getProperties().forEach((name, property) -> {
                switch (name) {
                    case "authSchemes": {
                        b.add(".addProperty($T.of($S), $T.fromTuple($T.asList(", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), "authSchemes", this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), Arrays.class});
                        Iterator authSchemesIter = ((JrsArray)property).elements();
                        while (authSchemesIter.hasNext()) {
                            b.add("$T.fromRecord($T.of(", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), MapUtils.class});
                            JrsObject authScheme = (JrsObject)authSchemesIter.next();
                            Iterator authSchemeFieldsIter = authScheme.fieldNames();
                            while (authSchemeFieldsIter.hasNext()) {
                                String schemeProp = (String)authSchemeFieldsIter.next();
                                JrsValue propValue = authScheme.get(schemeProp);
                                b.add("$T.of($S), ", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), schemeProp});
                                if ("signingRegionSet".equalsIgnoreCase(schemeProp)) {
                                    b.add("$T.fromTuple($T.asList(", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), Arrays.class});
                                    Iterator signingRegions = ((JrsArray)propValue).elements();
                                    while (signingRegions.hasNext()) {
                                        JrsString region = (JrsString)signingRegions.next();
                                        b.add("$T.fromStr($S)", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), region.getValue()});
                                        if (!signingRegions.hasNext()) continue;
                                        b.add(", ", new Object[0]);
                                    }
                                    b.add("))", new Object[0]);
                                } else if ("disableDoubleEncoding".equalsIgnoreCase(schemeProp)) {
                                    b.add("$T.fromBool($L)", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), ((JrsBoolean)propValue).booleanValue()});
                                } else {
                                    b.add("$T.fromStr($S)", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Literal"), ((JrsString)propValue).getValue()});
                                }
                                if (!authSchemeFieldsIter.hasNext()) continue;
                                b.add(", ", new Object[0]);
                            }
                            b.add("))", new Object[0]);
                            if (!authSchemesIter.hasNext()) continue;
                            b.add(", ", new Object[0]);
                        }
                        b.add(")))", new Object[0]);
                        break;
                    }
                }
            });
        }
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private CodeBlock condition(ConditionModel model) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Condition")}).add(".fn($L.validate())", new Object[]{this.fnNode(model)});
        if (model.getAssign() != null) {
            b.add(".result($S)", new Object[]{model.getAssign()});
        }
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private CodeBlock fnNode(ConditionModel model) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("FnNode")}).add(".fn($S)", new Object[]{model.getFn()}).add(".argv($T.asList(", new Object[]{Arrays.class});
        List<TreeNode> args = model.getArgv();
        for (int i = 0; i < args.size(); ++i) {
            b.add("$L", new Object[]{this.expr(args.get(i))});
            if (i + 1 >= args.size()) continue;
            b.add(",", new Object[0]);
        }
        b.add("))", new Object[0]);
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private CodeBlock expr(TreeNode n) {
        if (n.isValueNode()) {
            return this.valueExpr((JrsValue)n);
        }
        if (n.isObject()) {
            return this.objectExpr((JrsObject)n);
        }
        throw new RuntimeException("Don't know how to create expression from " + n);
    }

    private CodeBlock valueExpr(JrsValue n) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.of(", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Expr")});
        JsonToken token = n.asToken();
        switch (token) {
            case VALUE_STRING: {
                b.add("$S", new Object[]{((JrsString)n).getValue()});
                break;
            }
            case VALUE_NUMBER_INT: {
                b.add("$L", new Object[]{((JrsNumber)n).getValue().intValue()});
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                b.add("$L", new Object[]{((JrsBoolean)n).booleanValue()});
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to create expression JSON type " + token);
            }
        }
        b.add(")", new Object[0]);
        return b.build();
    }

    private CodeBlock objectExpr(JrsObject n) {
        CodeBlock.Builder b = CodeBlock.builder();
        JrsValue ref = n.get("ref");
        JrsValue fn = n.get("fn");
        if (ref != null) {
            b.add("$T.ref($T.of($S))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Expr"), this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), ref.asText()});
        } else if (fn != null) {
            String name = fn.asText();
            CodeBlock.Builder fnNode = CodeBlock.builder();
            fnNode.add("$T.builder()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("FnNode")}).add(".fn($S)", new Object[]{name});
            JrsArray argv = (JrsArray)n.get("argv");
            fnNode.add(".argv($T.asList(", new Object[]{Arrays.class});
            Iterator iter = argv.elements();
            while (iter.hasNext()) {
                fnNode.add(this.expr((TreeNode)iter.next()));
                if (!iter.hasNext()) continue;
                fnNode.add(",", new Object[0]);
            }
            fnNode.add(")).build().validate()", new Object[0]);
            b.add(fnNode.build());
        }
        return b.build();
    }

    private String nextRuleMethodName() {
        String n = String.format("%s%d", RULE_METHOD_PREFIX, this.ruleCounter);
        ++this.ruleCounter;
        return n;
    }
}

