/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.token.credentials.aws.DefaultAwsTokenProvider;
import software.amazon.awssdk.auth.token.signer.aws.BearerTokenSigner;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceClientConfigurationUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.endpointdiscovery.providers.DefaultEndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class BaseClientBuilderClass
implements ClassSpec {
    private static final ParameterizedTypeName GENERIC_AUTH_SCHEME_TYPE = ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
    private final IntermediateModel model;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final ClassName sdkClientConfigurationUtilClassName;
    private final String basePackage;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final ServiceClientConfigurationUtils configurationUtils;

    public BaseClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
        this.sdkClientConfigurationUtilClassName = ClassName.get((String)model.getMetadata().getFullClientInternalPackageName(), (String)"SdkClientConfigurationUtil", (String[])new String[0]);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(model);
        this.configurationUtils = new ServiceClientConfigurationUtils(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(SdkInternalApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).superclass((TypeName)PoetUtils.createParameterizedTypeName(AwsDefaultClientBuilder.class, "B", "C")).addJavadoc("Internal base class for {@link $T} and {@link $T}.", new Object[]{ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0])});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addField(FieldSpec.builder(Boolean.TYPE, (String)"endpointDiscoveryEnabled", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).initializer(this.resolveDefaultEndpointDiscovery() ? "true" : "false", new Object[0]).build());
        }
        if (this.authSchemeSpecUtils.useSraAuth()) {
            builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), GENERIC_AUTH_SCHEME_TYPE}), (String)"additionalAuthSchemes", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>()", new Object[]{HashMap.class}).build());
        }
        builder.addMethod(this.serviceEndpointPrefixMethod());
        builder.addMethod(this.serviceNameMethod());
        builder.addMethod(this.mergeServiceDefaultsMethod());
        this.mergeInternalDefaultsMethod().ifPresent(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        builder.addMethod(this.finalizeServiceConfigurationMethod());
        if (!this.authSchemeSpecUtils.useSraAuth()) {
            this.defaultAwsAuthSignerMethod().ifPresent(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        }
        builder.addMethod(this.signingNameMethod());
        builder.addMethod(this.defaultEndpointProviderMethod());
        if (this.authSchemeSpecUtils.useSraAuth()) {
            builder.addMethod(this.authSchemeProviderMethod());
            builder.addMethod(this.defaultAuthSchemeProviderMethod());
            builder.addMethod(this.putAuthSchemeMethod());
            builder.addMethod(this.authSchemesMethod());
        }
        if (this.hasClientContextParams()) {
            this.model.getClientContextParams().forEach((n, m) -> builder.addMethod(this.clientContextParamSetter((String)n, (ClientContextParam)m)));
        }
        if (this.hasSdkClientContextParams()) {
            this.model.getCustomizationConfig().getCustomClientContextParams().forEach((n, m) -> builder.addMethod(this.clientContextParamSetter((String)n, (ClientContextParam)m)));
        }
        if (this.model.getCustomizationConfig().getServiceConfig().getClassName() != null) {
            builder.addMethod(this.setServiceConfigurationMethod()).addMethod(this.beanStyleSetServiceConfigurationMethod());
        }
        if (AuthUtils.usesBearerAuth(this.model)) {
            builder.addMethod(this.defaultBearerTokenProviderMethod());
            if (!this.authSchemeSpecUtils.useSraAuth()) {
                builder.addMethod(this.defaultTokenAuthSignerMethod());
            }
        }
        builder.addMethod(this.setOverridesMethod());
        this.addServiceHttpConfigIfNeeded(builder, this.model);
        builder.addMethod(this.invokePluginsMethod());
        builder.addMethod(this.internalPluginsMethod());
        builder.addMethod(this.validateClientOptionsMethod());
        return builder.build();
    }

    private boolean resolveDefaultEndpointDiscovery() {
        return this.model.getEndpointOperation().map(OperationModel::isEndpointCacheRequired).orElse(false);
    }

    private MethodSpec signingNameMethod() {
        return MethodSpec.methodBuilder((String)"signingName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getSigningName()}).build();
    }

    private Optional<MethodSpec> defaultAwsAuthSignerMethod() {
        return this.awsAuthSignerDefinitionMethodBody().map(body -> MethodSpec.methodBuilder((String)"defaultSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(body).build());
    }

    private MethodSpec serviceEndpointPrefixMethod() {
        return MethodSpec.methodBuilder((String)"serviceEndpointPrefix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private MethodSpec serviceNameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getServiceName()}).build();
    }

    private MethodSpec mergeServiceDefaultsMethod() {
        boolean crc32FromCompressedDataEnabled = this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeServiceDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> c", new Object[0]);
        builder.addCode(".option($T.ENDPOINT_PROVIDER, defaultEndpointProvider())", new Object[]{SdkClientOption.class});
        if (this.authSchemeSpecUtils.useSraAuth()) {
            builder.addCode(".option($T.AUTH_SCHEME_PROVIDER, defaultAuthSchemeProvider())", new Object[]{SdkClientOption.class});
            builder.addCode(".option($T.AUTH_SCHEMES, authSchemes())", new Object[]{SdkClientOption.class});
        } else if (this.defaultAwsAuthSignerMethod().isPresent()) {
            builder.addCode(".option($T.SIGNER, defaultSigner())\n", new Object[]{SdkAdvancedClientOption.class});
        }
        builder.addCode(".option($T.CRC32_FROM_COMPRESSED_DATA_ENABLED, $L)\n", new Object[]{SdkClientOption.class, crc32FromCompressedDataEnabled});
        String clientConfigClassName = this.model.getCustomizationConfig().getServiceConfig().getClassName();
        if (StringUtils.isNotBlank((CharSequence)clientConfigClassName)) {
            builder.addCode(".option($T.SERVICE_CONFIGURATION, $T.builder().build())\n", new Object[]{SdkClientOption.class, ClassName.bestGuess((String)clientConfigClassName)});
        }
        if (AuthUtils.usesBearerAuth(this.model)) {
            builder.addCode(".option($T.TOKEN_IDENTITY_PROVIDER, defaultTokenProvider())\n", new Object[]{AwsClientOption.class});
            if (!this.authSchemeSpecUtils.useSraAuth()) {
                builder.addCode(".option($T.TOKEN_SIGNER, defaultTokenSigner())", new Object[]{SdkAdvancedClientOption.class});
            }
        }
        builder.addCode(");", new Object[0]);
        return builder.build();
    }

    private Optional<MethodSpec> mergeInternalDefaultsMethod() {
        String userAgent = this.model.getCustomizationConfig().getUserAgent();
        RetryMode defaultRetryMode = this.model.getCustomizationConfig().getDefaultRetryMode();
        if (userAgent == null && defaultRetryMode == null) {
            return Optional.empty();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeInternalDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> {\n", new Object[0]);
        if (userAgent != null) {
            builder.addCode("c.option($T.INTERNAL_USER_AGENT, $S);\n", new Object[]{SdkClientOption.class, userAgent});
        }
        if (defaultRetryMode != null) {
            builder.addCode("c.option($T.DEFAULT_RETRY_MODE, $T.$L);\n", new Object[]{SdkClientOption.class, RetryMode.class, defaultRetryMode.name()});
        }
        builder.addCode("});\n", new Object[0]);
        return Optional.of(builder.build());
    }

    private MethodSpec finalizeServiceConfigurationMethod() {
        String clientConfigClassName;
        String requestHandlerDirectory = Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
        String requestHandlerPath = String.format("%s/execution.interceptors", requestHandlerDirectory);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"finalizeServiceConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]);
        builder.addStatement("$T endpointInterceptors = new $T<>()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{ExecutionInterceptor.class}), ArrayList.class});
        ArrayList<ClassName> builtInInterceptors = new ArrayList<ClassName>();
        if (this.authSchemeSpecUtils.useSraAuth()) {
            builtInInterceptors.add(this.authSchemeSpecUtils.authSchemeInterceptor());
        }
        builtInInterceptors.add(this.endpointRulesSpecUtils.resolverInterceptorName());
        builtInInterceptors.add(this.endpointRulesSpecUtils.requestModifierInterceptorName());
        for (String string : this.model.getCustomizationConfig().getInterceptors()) {
            builtInInterceptors.add(ClassName.bestGuess((String)string));
        }
        for (ClassName className : builtInInterceptors) {
            builder.addStatement("endpointInterceptors.add(new $T())", new Object[]{className});
        }
        builder.addCode("$1T interceptorFactory = new $1T();\n", new Object[]{ClasspathInterceptorChainFactory.class}).addCode("$T<$T> interceptors = interceptorFactory.getInterceptors($S);\n", new Object[]{List.class, ExecutionInterceptor.class, requestHandlerPath});
        builder.addStatement("$T additionalInterceptors = new $T<>()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{ExecutionInterceptor.class}), ArrayList.class});
        builder.addStatement("interceptors = $T.mergeLists(endpointInterceptors, interceptors)", new Object[]{CollectionUtils.class});
        builder.addStatement("interceptors = $T.mergeLists(interceptors, additionalInterceptors)", new Object[]{CollectionUtils.class});
        builder.addCode("interceptors = $T.mergeLists(interceptors, config.option($T.EXECUTION_INTERCEPTORS));\n", new Object[]{CollectionUtils.class, SdkClientOption.class});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]).addStatement("$1T chain = new $1T(config)", new Object[]{DefaultEndpointDiscoveryProviderChain.class}).addStatement("endpointDiscoveryEnabled = chain.resolveEndpointDiscovery()", new Object[0]).endControlFlow();
        }
        if (StringUtils.isNotBlank((CharSequence)(clientConfigClassName = this.model.getCustomizationConfig().getServiceConfig().getClassName()))) {
            this.mergeServiceConfiguration(builder, clientConfigClassName);
        }
        if (this.model.getCustomizationConfig().useGlobalEndpoint()) {
            builder.addStatement("$T resolver = new UseGlobalEndpointResolver(config)", new Object[]{ClassName.get((String)"software.amazon.awssdk.services.s3.internal.endpoints", (String)"UseGlobalEndpointResolver", (String[])new String[0])});
        }
        builder.addStatement("$T builder = config.toBuilder()", new Object[]{SdkClientConfiguration.Builder.class});
        if (AuthUtils.usesBearerAuth(this.model)) {
            builder.addStatement("$T<? extends $T> identityProvider = config.option($T.TOKEN_IDENTITY_PROVIDER)", new Object[]{IdentityProvider.class, TokenIdentity.class, AwsClientOption.class});
            builder.beginControlFlow("if (identityProvider != null)", new Object[0]);
            builder.addStatement("$T identityProviders = config.option($T.IDENTITY_PROVIDERS)", new Object[]{IdentityProviders.class, SdkClientOption.class});
            builder.addStatement("builder.option($T.IDENTITY_PROVIDERS, identityProviders.toBuilder().putIdentityProvider(identityProvider).build())", new Object[]{SdkClientOption.class});
            builder.endControlFlow();
        }
        builder.addCode("builder.option($1T.EXECUTION_INTERCEPTORS, interceptors)", new Object[]{SdkClientOption.class});
        if (this.model.getCustomizationConfig().getServiceConfig().hasDualstackProperty()) {
            builder.addCode(".option($T.DUALSTACK_ENDPOINT_ENABLED, finalServiceConfig.dualstackEnabled())", new Object[]{AwsClientOption.class});
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasFipsProperty()) {
            builder.addCode(".option($T.FIPS_ENDPOINT_ENABLED, finalServiceConfig.fipsModeEnabled())", new Object[]{AwsClientOption.class});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addCode(".option($T.ENDPOINT_DISCOVERY_ENABLED, endpointDiscoveryEnabled)\n", new Object[]{SdkClientOption.class});
        }
        if (StringUtils.isNotBlank((CharSequence)this.model.getCustomizationConfig().getCustomRetryPolicy())) {
            builder.addCode(".option($1T.RETRY_POLICY, $2T.resolveRetryPolicy(config))", new Object[]{SdkClientOption.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getCustomRetryPolicy())});
        }
        if (StringUtils.isNotBlank((CharSequence)clientConfigClassName)) {
            builder.addCode(".option($T.SERVICE_CONFIGURATION, finalServiceConfig)", new Object[]{SdkClientOption.class});
        }
        if (this.model.getCustomizationConfig().useGlobalEndpoint()) {
            builder.addCode(".option($1T.USE_GLOBAL_ENDPOINT, resolver.resolve(config.option($1T.AWS_REGION)))", new Object[]{AwsClientOption.class});
        }
        if (this.hasClientContextParams()) {
            builder.addCode(".option($T.CLIENT_CONTEXT_PARAMS, clientContextParams.build())", new Object[]{SdkClientOption.class});
        }
        builder.addCode(";\n", new Object[0]);
        builder.addStatement("return builder.build()", new Object[0]);
        return builder.build();
    }

    private void mergeServiceConfiguration(MethodSpec.Builder builder, String clientConfigClassName) {
        ClassName clientConfigClass = ClassName.bestGuess((String)clientConfigClassName);
        builder.addCode("$1T.Builder serviceConfigBuilder = (($1T) config.option($2T.SERVICE_CONFIGURATION)).toBuilder();serviceConfigBuilder.profileFile(serviceConfigBuilder.profileFileSupplier() != null ? serviceConfigBuilder.profileFileSupplier() : config.option($2T.PROFILE_FILE_SUPPLIER));serviceConfigBuilder.profileName(serviceConfigBuilder.profileName() != null ? serviceConfigBuilder.profileName() : config.option($2T.PROFILE_NAME));", new Object[]{clientConfigClass, SdkClientOption.class});
        if (this.model.getCustomizationConfig().getServiceConfig().hasDualstackProperty()) {
            builder.addCode("if (serviceConfigBuilder.dualstackEnabled() != null) {", new Object[0]).addCode("    $T.validState(config.option($T.DUALSTACK_ENDPOINT_ENABLED) == null, \"Dualstack has been configured on both $L and the client/global level. Please limit dualstack configuration to one location.\");", new Object[]{Validate.class, AwsClientOption.class, clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    serviceConfigBuilder.dualstackEnabled(config.option($T.DUALSTACK_ENDPOINT_ENABLED));", new Object[]{AwsClientOption.class}).addCode("}", new Object[0]);
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasFipsProperty()) {
            builder.addCode("if (serviceConfigBuilder.fipsModeEnabled() != null) {", new Object[0]).addCode("    $T.validState(config.option($T.FIPS_ENDPOINT_ENABLED) == null, \"Fips has been configured on both $L and the client/global level. Please limit fips configuration to one location.\");", new Object[]{Validate.class, AwsClientOption.class, clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    serviceConfigBuilder.fipsModeEnabled(config.option($T.FIPS_ENDPOINT_ENABLED));", new Object[]{AwsClientOption.class}).addCode("}", new Object[0]);
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasUseArnRegionProperty()) {
            builder.addCode("if (serviceConfigBuilder.useArnRegionEnabled() != null) {", new Object[0]).addCode("    $T.validState(clientContextParams.get($T.USE_ARN_REGION) == null, \"UseArnRegion has been configured on both $L and the client/global level. Please limit UseArnRegion configuration to one location.\");", new Object[]{Validate.class, this.endpointRulesSpecUtils.clientContextParamsName(), clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    serviceConfigBuilder.useArnRegionEnabled(clientContextParams.get($T.USE_ARN_REGION));", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).addCode("}", new Object[0]);
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasMultiRegionEnabledProperty()) {
            builder.addCode("if (serviceConfigBuilder.multiRegionEnabled() != null) {", new Object[0]).addCode("    $T.validState(clientContextParams.get($T.DISABLE_MULTI_REGION_ACCESS_POINTS) == null, \"DisableMultiRegionAccessPoints has been configured on both $L and the client/global level. Please limit DisableMultiRegionAccessPoints configuration to one location.\");", new Object[]{Validate.class, this.endpointRulesSpecUtils.clientContextParamsName(), clientConfigClassName}).addCode("} else if (clientContextParams.get($T.DISABLE_MULTI_REGION_ACCESS_POINTS) != null) {", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).addCode("    serviceConfigBuilder.multiRegionEnabled(!clientContextParams.get($T.DISABLE_MULTI_REGION_ACCESS_POINTS));", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).addCode("}", new Object[0]);
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasForcePathTypeEnabledProperty()) {
            builder.addCode("if (serviceConfigBuilder.pathStyleAccessEnabled() != null) {", new Object[0]).addCode("    $T.validState(clientContextParams.get($T.FORCE_PATH_STYLE) == null, \"ForcePathStyle has been configured on both $L and the client/global level. Please limit ForcePathStyle configuration to one location.\");", new Object[]{Validate.class, this.endpointRulesSpecUtils.clientContextParamsName(), clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    serviceConfigBuilder.pathStyleAccessEnabled(clientContextParams.get($T.FORCE_PATH_STYLE));", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).addCode("}", new Object[0]);
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasAccelerateModeEnabledProperty()) {
            builder.addCode("if (serviceConfigBuilder.accelerateModeEnabled() != null) {", new Object[0]).addCode("    $T.validState(clientContextParams.get($T.ACCELERATE) == null, \"Accelerate has been configured on both $L and the client/global level. Please limit Accelerate configuration to one location.\");", new Object[]{Validate.class, this.endpointRulesSpecUtils.clientContextParamsName(), clientConfigClassName}).addCode("} else {", new Object[0]).addCode("    serviceConfigBuilder.accelerateModeEnabled(clientContextParams.get($T.ACCELERATE));", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).addCode("}", new Object[0]);
        }
        builder.addStatement("$T finalServiceConfig = serviceConfigBuilder.build()", new Object[]{clientConfigClass});
        if (this.model.getCustomizationConfig().getServiceConfig().hasUseArnRegionProperty()) {
            builder.addCode(CodeBlock.builder().addStatement("clientContextParams.put($T.USE_ARN_REGION, finalServiceConfig.useArnRegionEnabled())", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).build());
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasMultiRegionEnabledProperty()) {
            builder.addCode(CodeBlock.builder().addStatement("clientContextParams.put($T.DISABLE_MULTI_REGION_ACCESS_POINTS, !finalServiceConfig.multiRegionEnabled())", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).build());
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasForcePathTypeEnabledProperty()) {
            builder.addCode(CodeBlock.builder().addStatement("clientContextParams.put($T.FORCE_PATH_STYLE, finalServiceConfig.pathStyleAccessEnabled())", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).build());
        }
        if (this.model.getCustomizationConfig().getServiceConfig().hasAccelerateModeEnabledProperty()) {
            builder.addCode(CodeBlock.builder().addStatement("clientContextParams.put($T.ACCELERATE, finalServiceConfig.accelerateModeEnabled())", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName()}).build());
        }
    }

    private MethodSpec setServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("clientConfiguration.option($T.SERVICE_CONFIGURATION, serviceConfiguration)", new Object[]{SdkClientOption.class}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec beanStyleSetServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceConfig().getClassName(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"setServiceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("serviceConfiguration(serviceConfiguration)", new Object[0]).build();
    }

    private void addServiceHttpConfigIfNeeded(TypeSpec.Builder builder, IntermediateModel model) {
        String serviceDefaultFqcn = model.getCustomizationConfig().getServiceSpecificHttpConfig();
        boolean supportsH2 = model.getMetadata().supportsH2();
        if (serviceDefaultFqcn != null || supportsH2) {
            builder.addMethod(this.serviceSpecificHttpConfigMethod(serviceDefaultFqcn, supportsH2));
        }
    }

    private MethodSpec serviceSpecificHttpConfigMethod(String serviceDefaultFqcn, boolean supportsH2) {
        return MethodSpec.methodBuilder((String)"serviceHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode(this.serviceSpecificHttpConfigMethodBody(serviceDefaultFqcn, supportsH2)).build();
    }

    private CodeBlock serviceSpecificHttpConfigMethodBody(String serviceDefaultFqcn, boolean supportsH2) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (serviceDefaultFqcn != null) {
            builder.addStatement("$T result = $T.defaultHttpConfig()", new Object[]{AttributeMap.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getServiceSpecificHttpConfig())});
        } else {
            builder.addStatement("$1T result = $1T.empty()", new Object[]{AttributeMap.class});
        }
        if (supportsH2) {
            builder.addStatement("return result.merge(AttributeMap.builder().put($T.PROTOCOL, $T.HTTP2).build())", new Object[]{SdkHttpConfigurationOption.class, Protocol.class});
        } else {
            builder.addStatement("return result", new Object[0]);
        }
        return builder.build();
    }

    private Optional<CodeBlock> awsAuthSignerDefinitionMethodBody() {
        AuthType authType = this.model.getMetadata().getAuthType();
        switch (authType) {
            case V4: {
                return Optional.of(this.v4SignerDefinitionMethodBody());
            }
            case S3: 
            case S3V4: {
                return Optional.of(this.s3SignerDefinitionMethodBody());
            }
            case BEARER: 
            case NONE: {
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException("Unsupported signer type: " + (Object)((Object)authType));
    }

    private CodeBlock v4SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();", (Object[])new Object[]{Aws4Signer.class});
    }

    private CodeBlock s3SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();\n", (Object[])new Object[]{ClassName.get((String)"software.amazon.awssdk.auth.signer", (String)"AwsS3V4Signer", (String[])new String[0])});
    }

    private MethodSpec defaultEndpointProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultEndpointProvider").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.endpointRulesSpecUtils.providerInterfaceName()).addStatement("return $T.defaultProvider()", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName()}).build();
    }

    private MethodSpec authSchemeProviderMethod() {
        return MethodSpec.methodBuilder((String)"authSchemeProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)this.authSchemeSpecUtils.providerInterfaceName(), "authSchemeProvider", new Modifier[0]).addStatement("clientConfiguration.option($T.AUTH_SCHEME_PROVIDER, authSchemeProvider)", new Object[]{SdkClientOption.class}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec defaultAuthSchemeProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultAuthSchemeProvider").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)this.authSchemeSpecUtils.providerInterfaceName()).addStatement("return $T.defaultProvider()", new Object[]{this.authSchemeSpecUtils.providerInterfaceName()}).build();
    }

    private MethodSpec putAuthSchemeMethod() {
        return MethodSpec.methodBuilder((String)"putAuthScheme").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)GENERIC_AUTH_SCHEME_TYPE, "authScheme", new Modifier[0]).addStatement("additionalAuthSchemes.put(authScheme.schemeId(), authScheme)", new Object[0]).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec clientContextParamSetter(String name, ClientContextParam param) {
        String setterName = this.endpointRulesSpecUtils.paramMethodName(name);
        String keyName = this.model.getNamingStrategy().getEnumValueName(name);
        TypeName type = this.endpointRulesSpecUtils.toJavaType(param.getType());
        return MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(type, setterName, new Modifier[0]).addStatement("clientContextParams.put($T.$N, $N)", new Object[]{this.endpointRulesSpecUtils.clientContextParamsName(), keyName, setterName}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec defaultBearerTokenProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultTokenProvider").returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(TokenIdentity.class)})).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return $T.create()", new Object[]{DefaultAwsTokenProvider.class}).build();
    }

    private MethodSpec defaultTokenAuthSignerMethod() {
        return MethodSpec.methodBuilder((String)"defaultTokenSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return $T.create()", new Object[]{BearerTokenSigner.class}).build();
    }

    private MethodSpec authSchemesMethod() {
        ParameterizedTypeName returns = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"authSchemes").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)returns);
        Set<Class<?>> concreteAuthSchemeClasses = this.authSchemeSpecUtils.allServiceConcreteAuthSchemeClasses();
        builder.addStatement("$T schemes = new $T<>($L + this.additionalAuthSchemes.size())", new Object[]{returns, HashMap.class, concreteAuthSchemeClasses.size()});
        for (Class<?> concreteAuthScheme : concreteAuthSchemeClasses) {
            String instanceVariable = CodegenNamingUtils.lowercaseFirstChar((String)concreteAuthScheme.getSimpleName());
            builder.addStatement("$1T $2L = $1T.create()", new Object[]{concreteAuthScheme, instanceVariable});
            builder.addStatement("schemes.put($1N.schemeId(), $1N)", new Object[]{instanceVariable});
        }
        builder.addStatement("schemes.putAll(this.additionalAuthSchemes)", new Object[0]);
        builder.addStatement("return $T.unmodifiableMap(schemes)", new Object[]{Collections.class});
        return builder.build();
    }

    private MethodSpec invokePluginsMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"invokePlugins").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).returns(SdkClientConfiguration.class);
        builder.addStatement("$T internalPlugins = internalPlugins()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{SdkPlugin.class})});
        builder.addStatement("$T externalPlugins = plugins()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{SdkPlugin.class})}).beginControlFlow("if (internalPlugins.isEmpty() && externalPlugins.isEmpty())", new Object[0]).addStatement("return config", new Object[0]).endControlFlow();
        builder.addStatement("$T plugins = $T.mergeLists(internalPlugins, externalPlugins)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{SdkPlugin.class}), CollectionUtils.class});
        builder.addStatement("$1T.BuilderInternal serviceConfigBuilder = $1T.builder(config.toBuilder())", new Object[]{this.configurationUtils.serviceClientConfigurationBuilderClassName()});
        builder.addStatement("serviceConfigBuilder.overrideConfiguration(overrideConfiguration())", new Object[0]);
        builder.beginControlFlow("for ($T plugin : plugins)", new Object[]{SdkPlugin.class}).addStatement("plugin.configureClient(serviceConfigBuilder)", new Object[0]).endControlFlow();
        builder.addStatement("overrideConfiguration(serviceConfigBuilder.overrideConfiguration())", new Object[0]);
        builder.addStatement("return serviceConfigBuilder.buildSdkClientConfiguration()", new Object[0]);
        return builder.build();
    }

    private MethodSpec internalPluginsMethod() {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(SdkPlugin.class)});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"internalPlugins").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)parameterizedTypeName);
        builder.addStatement("$T internalPlugins = new $T<>()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{SdkPlugin.class}), ArrayList.class});
        ArrayList<ClassName> internalPlugins = new ArrayList<ClassName>();
        for (String string : this.model.getCustomizationConfig().getInternalPlugins()) {
            internalPlugins.add(ClassName.bestGuess((String)string));
        }
        for (ClassName className : internalPlugins) {
            builder.addStatement("internalPlugins.add(new $T())", new Object[]{className});
        }
        builder.addStatement("return internalPlugins", new Object[0]);
        return builder.build();
    }

    private MethodSpec setOverridesMethod() {
        return MethodSpec.methodBuilder((String)"setOverrides").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(SdkClientConfiguration.class, "configuration", new Modifier[0]).returns(SdkClientConfiguration.class).addStatement("$T overrideConfiguration = overrideConfiguration()", new Object[]{ClientOverrideConfiguration.class}).beginControlFlow("if (overrideConfiguration == null)", new Object[0]).addStatement("return configuration", new Object[0]).endControlFlow().addStatement("return $T.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build()", new Object[]{this.sdkClientConfigurationUtilClassName}).build();
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }

    private boolean hasClientContextParams() {
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        return clientContextParams != null && !clientContextParams.isEmpty();
    }

    private boolean hasSdkClientContextParams() {
        return this.model.getCustomizationConfig() != null && this.model.getCustomizationConfig().getCustomClientContextParams() != null && !this.model.getCustomizationConfig().getCustomClientContextParams().isEmpty();
    }

    private MethodSpec validateClientOptionsMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"validateClientOptions").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC}).addParameter(SdkClientConfiguration.class, "c", new Modifier[0]).returns(Void.TYPE);
        if (AuthUtils.usesAwsAuth(this.model) && !this.authSchemeSpecUtils.useSraAuth()) {
            builder.addStatement("$T.notNull(c.option($T.SIGNER), $S)", new Object[]{Validate.class, SdkAdvancedClientOption.class, "The 'overrideConfiguration.advancedOption[SIGNER]' must be configured in the client builder."});
        }
        if (AuthUtils.usesBearerAuth(this.model)) {
            if (!this.authSchemeSpecUtils.useSraAuth()) {
                builder.addStatement("$T.notNull(c.option($T.TOKEN_SIGNER), $S)", new Object[]{Validate.class, SdkAdvancedClientOption.class, "The 'overrideConfiguration.advancedOption[TOKEN_SIGNER]' must be configured in the client builder."});
            }
            builder.addStatement("$T.notNull(c.option($T.TOKEN_IDENTITY_PROVIDER), $S)", new Object[]{Validate.class, AwsClientOption.class, "The 'tokenProvider' must be configured in the client builder."});
        }
        return builder.build();
    }
}

