/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.PoetGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeInterceptorSpec;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeParamsSpec;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeProviderSpec;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.DefaultAuthSchemeParamsSpec;
import software.amazon.awssdk.codegen.poet.auth.scheme.EndpointBasedAuthSchemeProviderSpec;
import software.amazon.awssdk.codegen.poet.auth.scheme.ModelBasedAuthSchemeProviderSpec;

public final class AuthSchemeGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public AuthSchemeGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected List<GeneratorTask> createTasks() {
        AuthSchemeSpecUtils authSchemeSpecUtils = new AuthSchemeSpecUtils(this.model);
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(this.generateParamsInterface());
        tasks.add(this.generateProviderInterface());
        tasks.add(this.generateDefaultParamsImpl());
        tasks.add(this.generateModelBasedProvider());
        tasks.add(this.generateAuthSchemeInterceptor());
        if (authSchemeSpecUtils.useEndpointBasedAuthProvider()) {
            tasks.add(this.generateEndpointBasedProvider());
        }
        return tasks;
    }

    private GeneratorTask generateParamsInterface() {
        return new PoetGeneratorTask(this.authSchemeDir(), this.model.getFileHeader(), new AuthSchemeParamsSpec(this.model));
    }

    private GeneratorTask generateDefaultParamsImpl() {
        return new PoetGeneratorTask(this.authSchemeInternalDir(), this.model.getFileHeader(), new DefaultAuthSchemeParamsSpec(this.model));
    }

    private GeneratorTask generateProviderInterface() {
        return new PoetGeneratorTask(this.authSchemeDir(), this.model.getFileHeader(), new AuthSchemeProviderSpec(this.model));
    }

    private GeneratorTask generateModelBasedProvider() {
        return new PoetGeneratorTask(this.authSchemeInternalDir(), this.model.getFileHeader(), new ModelBasedAuthSchemeProviderSpec(this.model));
    }

    private GeneratorTask generateEndpointBasedProvider() {
        return new PoetGeneratorTask(this.authSchemeInternalDir(), this.model.getFileHeader(), new EndpointBasedAuthSchemeProviderSpec(this.model));
    }

    private GeneratorTask generateAuthSchemeInterceptor() {
        return new PoetGeneratorTask(this.authSchemeInternalDir(), this.model.getFileHeader(), new AuthSchemeInterceptorSpec(this.model));
    }

    private String authSchemeDir() {
        return this.generatorTaskParams.getPathProvider().getAuthSchemeDirectory();
    }

    private String authSchemeInternalDir() {
        return this.generatorTaskParams.getPathProvider().getAuthSchemeInternalDirectory();
    }
}

