/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import software.amazon.awssdk.codegen.emitters.CodeTransformer;
import software.amazon.awssdk.codegen.emitters.JavaCodeFormatter;
import software.amazon.awssdk.codegen.emitters.LinkRemover;
import software.amazon.awssdk.codegen.emitters.UnusedImportRemover;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.utils.StringUtils;

public class CodeWriter
extends StringWriter {
    private final CodeTransformer codeWriteTransformer;
    private final CodeTransformer codeComparisonTransformer = new LinkRemover();
    private final String dir;
    private final String file;

    public CodeWriter(String dir, String file) {
        this(dir, file, ".java", false);
    }

    public CodeWriter(String dir, String file, boolean disableFormatter) {
        this(dir, file, ".java", disableFormatter);
    }

    public CodeWriter(String dir, String file, String fileNameSuffix, boolean disableFormatter) {
        if (dir == null) {
            throw new IllegalArgumentException("Output Directory cannot be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("File name cannot be null.");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("File name suffix cannot be null.");
        }
        if (!file.endsWith(fileNameSuffix)) {
            file = file + fileNameSuffix;
        }
        this.dir = dir;
        this.file = file;
        Utils.createDirectory(dir);
        this.codeWriteTransformer = disableFormatter ? CodeTransformer.chain(new UnusedImportRemover()) : CodeTransformer.chain(new UnusedImportRemover(), new JavaCodeFormatter());
    }

    @Override
    public void flush() {
        block15: {
            try {
                Path outputFile = Paths.get(this.dir, this.file);
                String contents = this.getBuffer().toString();
                String formattedContents = this.codeWriteTransformer.apply(contents);
                if (this.fileSize(outputFile) == 0L) {
                    try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                        writer.write(formattedContents);
                        break block15;
                    }
                }
                this.validateFileContentMatches(outputFile, formattedContents);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private long fileSize(Path outputFile) throws IOException {
        try {
            return Files.size(outputFile);
        }
        catch (NoSuchFileException e) {
            return 0L;
        }
    }

    private void validateFileContentMatches(Path outputFile, String newFileContents) throws IOException {
        String newContentForComparison;
        byte[] currentFileBytes = Files.readAllBytes(outputFile);
        String currentFileContents = new String(currentFileBytes, StandardCharsets.UTF_8);
        String currentContentForComparison = this.codeComparisonTransformer.apply(currentFileContents);
        if (!StringUtils.equals((String)currentContentForComparison, (String)(newContentForComparison = this.codeComparisonTransformer.apply(newFileContents)))) {
            throw new IllegalStateException("Attempted to clobber existing file (" + outputFile + ") with a new file that has different content. This may indicate forgetting to clean up old generated files before running the generator?\nExisting file: \n" + currentContentForComparison + "\n\nNew file: \n" + newContentForComparison);
        }
    }
}

