/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.model.service.ContextParam;
import software.amazon.awssdk.codegen.model.service.EndpointTrait;
import software.amazon.awssdk.codegen.model.service.HostPrefixProcessor;
import software.amazon.awssdk.codegen.model.service.StaticContextParam;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.StringUtils;

public class EndpointResolverInterceptorSpec
implements ClassSpec {
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final PoetExtension poetExtension;

    public EndpointResolverInterceptorSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.poetExtension = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface(ExecutionInterceptor.class);
        b.addMethod(this.modifyRequestMethod());
        b.addMethod(this.ruleParams());
        b.addMethod(this.setContextParams());
        this.addContextParamMethods(b);
        b.addMethod(this.setStaticContextParamsMethod());
        this.addStaticContextParamMethods(b);
        if (this.hasClientContextParams()) {
            b.addMethod(this.setClientContextParamsMethod());
        }
        b.addMethod(this.hostPrefixMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.resolverInterceptorName();
    }

    private MethodSpec modifyRequestMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"modifyRequest").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(SdkRequest.class).addParameter(Context.ModifyRequest.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        String providerVar = "provider";
        b.beginControlFlow("if ($1T.endpointIsDiscovered(executionAttributes))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.addStatement("return context.request()", new Object[0]);
        b.endControlFlow();
        b.addStatement("$1T $2N = ($1T) executionAttributes.getAttribute($3T.ENDPOINT_PROVIDER)", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName(), providerVar, SdkInternalExecutionAttribute.class});
        b.beginControlFlow("try", new Object[0]);
        b.addStatement("$T result = $N.resolveEndpoint(ruleParams(context, executionAttributes)).join()", new Object[]{Endpoint.class, providerVar});
        b.beginControlFlow("if (!$T.disableHostPrefixInjection(executionAttributes))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.addStatement("$T hostPrefix = hostPrefix(executionAttributes.getAttribute($T.OPERATION_NAME), context.request())", new Object[]{ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{String.class}), SdkExecutionAttribute.class});
        b.beginControlFlow("if (hostPrefix.isPresent())", new Object[0]);
        b.addStatement("result = $T.addHostPrefix(result, hostPrefix.get())", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.endControlFlow();
        b.endControlFlow();
        b.addStatement("executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, result)", new Object[0]);
        b.addStatement("return context.request()", new Object[0]);
        b.endControlFlow();
        b.beginControlFlow("catch ($T e)", new Object[]{CompletionException.class});
        b.addStatement("$T cause = e.getCause()", new Object[]{Throwable.class});
        b.beginControlFlow("if (cause instanceof $T)", new Object[]{SdkClientException.class});
        b.addStatement("throw ($T) cause", new Object[]{SdkClientException.class});
        b.endControlFlow();
        b.beginControlFlow("else", new Object[0]);
        b.addStatement("throw $T.create($S, cause)", new Object[]{SdkClientException.class, "Endpoint resolution failed"});
        b.endControlFlow();
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec ruleParams() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"ruleParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)this.endpointRulesSpecUtils.parametersClassName()).addParameter(Context.ModifyRequest.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        b.addStatement("$T builder = $T.builder()", new Object[]{this.paramsBuilderClass(), this.endpointRulesSpecUtils.parametersClassName()});
        b.addStatement("setStaticContextParams(builder, executionAttributes.getAttribute($T.OPERATION_NAME))", new Object[]{AwsExecutionAttribute.class});
        b.addStatement("setContextParams(builder, executionAttributes.getAttribute($T.OPERATION_NAME), context.request())", new Object[]{AwsExecutionAttribute.class});
        if (this.hasClientContextParams()) {
            b.addStatement("setClientContextParams(builder, executionAttributes)", new Object[0]);
        }
        Map<String, ParameterModel> parameters = this.model.getEndpointRuleSetModel().getParameters();
        parameters.forEach((n, m) -> {
            String builtInFn;
            if (m.getBuiltInEnum() == null) {
                return;
            }
            String setterName = this.endpointRulesSpecUtils.paramMethodName((String)n);
            switch (m.getBuiltInEnum()) {
                case AWS_REGION: {
                    builtInFn = "regionBuiltIn";
                    break;
                }
                case AWS_USE_DUAL_STACK: {
                    builtInFn = "dualStackEnabledBuiltIn";
                    break;
                }
                case AWS_USE_FIPS: {
                    builtInFn = "fipsEnabledBuiltIn";
                    break;
                }
                case SDK_ENDPOINT: {
                    builtInFn = "endpointBuiltIn";
                    break;
                }
                case AWS_S3_USE_GLOBAL_ENDPOINT: {
                    builtInFn = "useGlobalEndpointBuiltIn";
                    break;
                }
                case AWS_S3_ACCELERATE: 
                case AWS_S3_DISABLE_MULTI_REGION_ACCESS_POINTS: 
                case AWS_S3_FORCE_PATH_STYLE: 
                case AWS_S3_USE_ARN_REGION: 
                case AWS_S3_CONTROL_USE_ARN_REGION: 
                case AWS_STS_USE_GLOBAL_ENDPOINT: {
                    return;
                }
                default: {
                    throw new RuntimeException("Don't know how to set built-in " + (Object)((Object)m.getBuiltInEnum()));
                }
            }
            b.addStatement("builder.$N($T.$N(executionAttributes))", new Object[]{setterName, this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils"), builtInFn});
        });
        b.addStatement("return builder.build()", new Object[0]);
        return b.build();
    }

    private ClassName paramsBuilderClass() {
        return this.endpointRulesSpecUtils.parametersClassName().nestedClass("Builder");
    }

    private MethodSpec addStaticContextParamsMethod(OperationModel opModel) {
        String methodName = this.staticContextParamsMethodName(opModel);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(Void.TYPE).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]);
        opModel.getStaticContextParams().forEach((n, m) -> {
            String setterName = this.endpointRulesSpecUtils.paramMethodName((String)n);
            TreeNode value = m.getValue();
            switch (value.asToken()) {
                case VALUE_STRING: {
                    b.addStatement("params.$N($S)", new Object[]{setterName, ((JrsString)value).getValue()});
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    b.addStatement("params.$N($L)", new Object[]{setterName, ((JrsBoolean)value).booleanValue()});
                    break;
                }
                default: {
                    throw new RuntimeException("Don't know how to set parameter of type " + value.asToken());
                }
            }
        });
        return b.build();
    }

    private String staticContextParamsMethodName(OperationModel opModel) {
        return opModel.getMethodName() + "StaticContextParams";
    }

    private boolean hasStaticContextParams(OperationModel opModel) {
        Map<String, StaticContextParam> staticContextParams = opModel.getStaticContextParams();
        return staticContextParams != null && !staticContextParams.isEmpty();
    }

    private void addStaticContextParamMethods(TypeSpec.Builder classBuilder) {
        Map<String, OperationModel> operations = this.model.getOperations();
        operations.forEach((n, m) -> {
            if (this.hasStaticContextParams((OperationModel)m)) {
                classBuilder.addMethod(this.addStaticContextParamsMethod((OperationModel)m));
            }
        });
    }

    private void addContextParamMethods(TypeSpec.Builder classBuilder) {
        Map<String, OperationModel> operations = this.model.getOperations();
        operations.forEach((n, m) -> {
            if (this.hasContextParams((OperationModel)m)) {
                classBuilder.addMethod(this.setContextParamsMethod((OperationModel)m));
            }
        });
    }

    private MethodSpec setStaticContextParamsMethod() {
        Map<String, OperationModel> operations = this.model.getOperations();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setStaticContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(String.class, "operationName", new Modifier[0]).returns(Void.TYPE);
        b.beginControlFlow("switch (operationName)", new Object[0]);
        operations.forEach((n, m) -> {
            if (!this.hasStaticContextParams((OperationModel)m)) {
                return;
            }
            b.addCode("case $S:", new Object[]{n});
            b.addStatement("$N(params)", new Object[]{this.staticContextParamsMethodName((OperationModel)m)});
            b.addStatement("break", new Object[0]);
        });
        b.addCode("default:", new Object[0]);
        b.addStatement("break", new Object[0]);
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec setContextParams() {
        Map<String, OperationModel> operations = this.model.getOperations();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(String.class, "operationName", new Modifier[0]).addParameter(SdkRequest.class, "request", new Modifier[0]).returns(Void.TYPE);
        b.beginControlFlow("switch (operationName)", new Object[0]);
        operations.forEach((n, m) -> {
            if (!this.hasContextParams((OperationModel)m)) {
                return;
            }
            String requestClassName = this.model.getNamingStrategy().getRequestClassName(m.getOperationName());
            ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
            b.addCode("case $S:", new Object[]{n});
            b.addStatement("setContextParams(params, ($T) request)", new Object[]{requestClass});
            b.addStatement("break", new Object[0]);
        });
        b.addCode("default:", new Object[0]);
        b.addStatement("break", new Object[0]);
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec setContextParamsMethod(OperationModel opModel) {
        String requestClassName = this.model.getNamingStrategy().getRequestClassName(opModel.getOperationName());
        ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter((TypeName)requestClass, "request", new Modifier[0]).returns(Void.TYPE);
        opModel.getInputShape().getMembers().forEach(m -> {
            ContextParam param = m.getContextParam();
            if (param == null) {
                return;
            }
            String setterName = this.endpointRulesSpecUtils.paramMethodName(param.getName());
            b.addStatement("params.$N(request.$N())", new Object[]{setterName, m.getFluentGetterMethodName()});
        });
        return b.build();
    }

    private boolean hasContextParams(OperationModel opModel) {
        return opModel.getInputShape().getMembers().stream().anyMatch(m -> m.getContextParam() != null);
    }

    private boolean hasClientContextParams() {
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        return clientContextParams != null && !clientContextParams.isEmpty();
    }

    private MethodSpec setClientContextParamsMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setClientContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]).returns(Void.TYPE);
        b.addStatement("$T clientContextParams = executionAttributes.getAttribute($T.CLIENT_CONTEXT_PARAMS)", new Object[]{AttributeMap.class, SdkInternalExecutionAttribute.class});
        ClassName paramsClass = this.endpointRulesSpecUtils.clientContextParamsName();
        Map<String, ClientContextParam> params = this.model.getClientContextParams();
        params.forEach((n, m) -> {
            String attrName = this.endpointRulesSpecUtils.clientContextParamName((String)n);
            b.addStatement("$T.ofNullable(clientContextParams.get($T.$N)).ifPresent(params::$N)", new Object[]{Optional.class, paramsClass, attrName, this.endpointRulesSpecUtils.paramMethodName((String)n)});
        });
        return b.build();
    }

    private MethodSpec hostPrefixMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"hostPrefix").returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{String.class})).addParameter(String.class, "operationName", new Modifier[0]).addParameter(SdkRequest.class, "request", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        builder.beginControlFlow("switch (operationName)", new Object[0]);
        this.model.getOperations().forEach((name, opModel) -> {
            String hostPrefix = this.getHostPrefix((OperationModel)opModel);
            if (StringUtils.isBlank((CharSequence)hostPrefix)) {
                return;
            }
            builder.beginControlFlow("case $S:", new Object[]{name});
            HostPrefixProcessor processor = new HostPrefixProcessor(hostPrefix);
            if (processor.c2jNames().isEmpty()) {
                builder.addStatement("return $T.of($S)", new Object[]{Optional.class, processor.hostWithStringSpecifier()});
            } else {
                String requestVar = opModel.getInput().getVariableName();
                processor.c2jNames().forEach(c2jName -> builder.addStatement("$1T.validateHostnameCompliant(request.getValueForField($2S, $3T.class).orElse(null), $2S, $4S)", new Object[]{HostnameValidator.class, c2jName, String.class, requestVar}));
                builder.addCode("return $T.of($T.format($S, ", new Object[]{Optional.class, String.class, processor.hostWithStringSpecifier()});
                ListIterator<String> c2jNamesIter = processor.c2jNames().listIterator();
                while (c2jNamesIter.hasNext()) {
                    builder.addCode("request.getValueForField($S, $T.class).get()", new Object[]{c2jNamesIter.next(), String.class});
                    if (!c2jNamesIter.hasNext()) continue;
                    builder.addCode(",", new Object[0]);
                }
                builder.addStatement("))", new Object[0]);
            }
            builder.endControlFlow();
        });
        builder.addCode("default:", new Object[0]);
        builder.addStatement("return $T.empty()", new Object[]{Optional.class});
        builder.endControlFlow();
        return builder.build();
    }

    private String getHostPrefix(OperationModel opModel) {
        EndpointTrait endpointTrait = opModel.getEndpointTrait();
        if (endpointTrait == null) {
            return null;
        }
        return endpointTrait.getHostPrefix();
    }
}

