/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;

public class DelegatingAsyncClientClass
extends AsyncClientInterface {
    private final IntermediateModel model;
    private final ClassName className;
    private final PoetExtension poetExtensions;

    public DelegatingAsyncClientClass(IntermediateModel model) {
        super(model);
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullInternalPackageName(), (String)("Delegating" + model.getMetadata().getAsyncInterface()), (String[])new String[0]);
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
        TypeSpec.Builder result = PoetUtils.createClassBuilder(this.className);
        result.addSuperinterface((TypeName)interfaceClass).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addField(FieldSpec.builder((TypeName)interfaceClass, (String)"delegate", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethods(this.operations()).addMethod(this.closeMethod());
        result.addMethod(this.constructor(interfaceClass));
        if (this.model.getCustomizationConfig().getUtilitiesMethod() != null) {
            result.addMethod(this.utilitiesMethod());
        }
        if (this.model.hasWaiters()) {
            result.addMethod(this.waiterMethod());
        }
        return result.build();
    }

    private MethodSpec constructor(ClassName interfaceClass) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)interfaceClass, "delegate", new Modifier[0]).addStatement("this.delegate = delegate", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        if (opModel.hasStreamingInput() || opModel.hasStreamingOutput()) {
            String variableName = opModel.hasStreamingInput() ? "requestBody" : "asyncResponseTransformer";
            return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N, $N)", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), variableName});
        }
        if (opModel.hasEventStreamInput() && opModel.hasEventStreamOutput()) {
            return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N, $N, $N)", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), "requestStream", "asyncResponseTransformer"});
        }
        if (opModel.hasEventStreamInput() || opModel.hasEventStreamOutput()) {
            String variableName = opModel.hasEventStreamInput() ? "requestStream" : "asyncResponseHandler";
            return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N, $N)", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), variableName});
        }
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N)", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName()});
    }

    @Override
    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        return builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return delegate.$N($N)", new Object[]{methodName, opModel.getInput().getVariableName()});
    }

    @Override
    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.$N()", new Object[]{"utilities"});
    }

    @Override
    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return delegate.waiter()", new Object[0]);
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("delegate.close()", new Object[0]).build();
    }
}

