/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.io.IOException;
import java.io.Writer;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.internal.Utils;

public final class SimpleGeneratorTask
extends GeneratorTask {
    private final Writer writer;
    private final String fileHeader;
    private String fileName;
    private final String contents;

    public SimpleGeneratorTask(String outputDirectory, String fileName, String fileHeader, String contents) {
        this.fileHeader = fileHeader;
        this.writer = new CodeWriter(outputDirectory, fileName);
        this.fileName = fileName;
        this.contents = contents;
    }

    @Override
    public void compute() {
        try {
            this.writer.write(this.fileHeader + "\n");
            this.writer.write(this.contents);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error creating file %s", this.fileName), e);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
    }
}

