/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.utils.IoUtils;

public final class WaitersRuntimeGeneratorTask
extends BaseGeneratorTasks {
    public static final String RUNTIME_CLASS_NAME = "WaitersRuntime";
    private final String waitersInternalClassDir;
    private final String waitersInternalPackageName;
    private final String fileHeader;
    private final String runtimeClassCode;

    public WaitersRuntimeGeneratorTask(GeneratorTaskParams generatorTaskParams) {
        super(generatorTaskParams);
        this.waitersInternalClassDir = generatorTaskParams.getPathProvider().getWaitersInternalDirectory();
        this.waitersInternalPackageName = generatorTaskParams.getModel().getMetadata().getFullWaitersInternalPackageName();
        this.fileHeader = generatorTaskParams.getModel().getFileHeader();
        this.runtimeClassCode = WaitersRuntimeGeneratorTask.loadWaitersRuntimeCode();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        String codeContents = "package " + this.waitersInternalPackageName + ";\n\n" + this.runtimeClassCode;
        String fileName = "WaitersRuntime.java";
        return Collections.singletonList(new SimpleGeneratorTask(this.waitersInternalClassDir, fileName, this.fileHeader, codeContents));
    }

    private static String loadWaitersRuntimeCode() {
        try {
            InputStream is = WaitersRuntimeGeneratorTask.class.getResourceAsStream("/software/amazon/awssdk/codegen/waiters/WaitersRuntime.java.resource");
            return IoUtils.toUtf8String((InputStream)is);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

