/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.waiters.BaseWaiterClassSpec;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

public class AsyncWaiterClassSpec
extends BaseWaiterClassSpec {
    private final PoetExtension poetExtensions;
    private final ClassName className;
    private final IntermediateModel model;
    private final String modelPackage;

    public AsyncWaiterClassSpec(IntermediateModel model) {
        super(model, ClassName.get(AsyncWaiter.class));
        this.model = model;
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.poetExtensions = new PoetExtension(model);
        this.className = this.poetExtensions.getAsyncWaiterClass();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected ClassName clientClassName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
    }

    protected ParameterizedTypeName getWaiterResponseType(OperationModel opModel) {
        ClassName pojoResponse = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ParameterizedTypeName waiterResponse = ParameterizedTypeName.get((ClassName)ClassName.get(WaiterResponse.class), (TypeName[])new TypeName[]{pojoResponse});
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{waiterResponse});
    }

    @Override
    protected ClassName interfaceClassName() {
        return this.poetExtensions.getAsyncWaiterInterface();
    }

    @Override
    protected Optional<String> additionalWaiterConfig() {
        return Optional.of(".scheduledExecutorService(executorService)");
    }

    @Override
    protected void additionalConstructorInitialization(MethodSpec.Builder method) {
        method.beginControlFlow("if (builder.executorService == null)", new Object[0]).addStatement("this.executorService = $T.newScheduledThreadPool(1, new $T().threadNamePrefix($S).build())", new Object[]{Executors.class, ThreadFactoryBuilder.class, "waiters-ScheduledExecutor"}).addStatement("attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, this.executorService)", new Object[0]).endControlFlow();
        method.beginControlFlow("else", new Object[0]).addStatement("this.executorService = builder.executorService", new Object[0]).endControlFlow();
    }

    @Override
    protected void additionalTypeSpecModification(TypeSpec.Builder type) {
        type.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(WaiterAttribute.class, (Type[])new Type[]{ScheduledExecutorService.class}), (String)"SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>($T.class)", new Object[]{WaiterAttribute.class, ScheduledExecutorService.class}).build());
        type.addField(FieldSpec.builder(ScheduledExecutorService.class, (String)"executorService", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    @Override
    protected void additionalBuilderTypeSpecModification(TypeSpec.Builder type) {
        type.addField((TypeName)ClassName.get(ScheduledExecutorService.class), "executorService", new Modifier[]{Modifier.PRIVATE});
        type.addMethod(MethodSpec.methodBuilder((String)"scheduledExecutorService").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)ClassName.get(ScheduledExecutorService.class), "executorService", new Modifier[0]).addStatement("this.executorService = executorService", new Object[0]).addStatement("return this", new Object[0]).returns((TypeName)this.interfaceClassName().nestedClass("Builder")).build());
    }
}

