/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.config.customization.UtilitiesMethod;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.Ec2ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.JsonProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.specs.XmlProtocolSpec;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.Logger;

public class SyncClientClass
implements ClassSpec {
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final ProtocolSpec protocolSpec;

    public SyncClientClass(GeneratorTaskParams taskParams) {
        this.model = taskParams.getModel();
        this.poetExtensions = taskParams.getPoetExtensions();
        this.className = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncClient());
        this.protocolSpec = SyncClientClass.getProtocolSpecs(this.poetExtensions, this.model);
    }

    @Override
    public TypeSpec poetSpec() {
        ClassName interfaceClass = this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
        TypeSpec.Builder classBuilder = PoetUtils.createClassBuilder(this.className).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)interfaceClass).addJavadoc("Internal implementation of {@link $1T}.\n\n@see $1T#builder()", new Object[]{interfaceClass}).addField(this.logger()).addField(SyncClientHandler.class, "clientHandler", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(this.protocolSpec.protocolFactory(this.model)).addField(SdkClientConfiguration.class, "clientConfiguration", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(this.constructor()).addMethod(this.nameMethod()).addMethods(this.protocolSpec.additionalMethods()).addMethods(this.operations()).addMethod(this.resolveMetricPublishersMethod());
        this.protocolSpec.createErrorResponseHandler().ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        classBuilder.addMethod(this.protocolSpec.initProtocolFactory(this.model));
        classBuilder.addMethod(this.closeMethod());
        if (this.model.hasPaginators()) {
            classBuilder.addMethod(ClientClassUtils.applyPaginatorUserAgentMethod(this.poetExtensions, this.model));
        }
        if (this.model.containsRequestSigners()) {
            classBuilder.addMethod(ClientClassUtils.applySignerOverrideMethod(this.poetExtensions, this.model));
        }
        if (this.model.getCustomizationConfig().getUtilitiesMethod() != null) {
            classBuilder.addMethod(this.utilitiesMethod());
        }
        this.model.getEndpointOperation().ifPresent(o -> classBuilder.addField(EndpointDiscoveryRefreshCache.class, "endpointDiscoveryCache", new Modifier[]{Modifier.PRIVATE}));
        if (this.model.hasWaiters()) {
            classBuilder.addMethod(this.waiterMethod());
        }
        return classBuilder.build();
    }

    private FieldSpec logger() {
        return FieldSpec.builder(Logger.class, (String)"log", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.loggerFor($T.class)", new Object[]{Logger.class, this.className}).build();
    }

    private MethodSpec nameMethod() {
        return MethodSpec.methodBuilder((String)"serviceName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return SERVICE_NAME", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private MethodSpec constructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(SdkClientConfiguration.class, "clientConfiguration", new Modifier[0]).addStatement("this.clientHandler = new $T(clientConfiguration)", new Object[]{this.protocolSpec.getClientHandlerClass()}).addStatement("this.clientConfiguration = clientConfiguration", new Object[0]);
        FieldSpec protocolFactoryField = this.protocolSpec.protocolFactory(this.model);
        if (this.model.getMetadata().isJsonProtocol()) {
            builder.addStatement("this.$N = init($T.builder()).build()", new Object[]{protocolFactoryField.name, protocolFactoryField.type});
        } else {
            builder.addStatement("this.$N = init()", new Object[]{protocolFactoryField.name});
        }
        if (this.model.getEndpointOperation().isPresent()) {
            builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED))", new Object[0]);
            builder.addStatement("this.endpointDiscoveryCache = $T.create($T.create(this))", new Object[]{EndpointDiscoveryRefreshCache.class, this.poetExtensions.getClientClass(this.model.getNamingStrategy().getServiceName() + "EndpointDiscoveryCacheLoader")});
            if (this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                builder.beginControlFlow("if (clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE)", new Object[0]);
                builder.addStatement("log.warn(() -> $S)", new Object[]{"Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended."});
                builder.endControlFlow();
            }
            builder.endControlFlow();
        }
        return builder.build();
    }

    private List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().filter(o -> !o.hasEventStreamInput()).filter(o -> !o.hasEventStreamOutput()).map(this::operationMethodSpecs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MethodSpec> operationMethodSpecs(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        MethodSpec.Builder method = SyncClientInterface.operationMethodSignature(this.model, opModel).addAnnotation(Override.class).addCode(ClientClassUtils.callApplySignerOverrideMethod(opModel)).addCode(this.protocolSpec.responseHandler(this.model, opModel));
        this.protocolSpec.errorResponseHandler(opModel).ifPresent(arg_0 -> ((MethodSpec.Builder)method).addCode(arg_0));
        if (opModel.getEndpointDiscovery() != null) {
            method.addStatement("boolean endpointDiscoveryEnabled = clientConfiguration.option(SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)", new Object[0]);
            method.addStatement("boolean endpointOverridden = clientConfiguration.option(SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE", new Object[0]);
            if (opModel.getEndpointDiscovery().isRequired()) {
                if (!this.model.getCustomizationConfig().allowEndpointOverrideForEndpointDiscoveryRequiredOperations()) {
                    method.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but an endpoint override was specified when the client was created. This is not supported."});
                    method.endControlFlow();
                    method.beginControlFlow("if (!endpointDiscoveryEnabled)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery, but endpoint discovery was disabled on the client."});
                    method.endControlFlow();
                } else {
                    method.beginControlFlow("if (endpointOverridden)", new Object[0]);
                    method.addStatement("endpointDiscoveryEnabled = false", new Object[0]);
                    method.nextControlFlow("else if (!endpointDiscoveryEnabled)", new Object[0]);
                    method.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created."});
                    method.endControlFlow();
                }
            }
            method.addStatement("$T cachedEndpoint = null", new Object[]{URI.class});
            method.beginControlFlow("if (endpointDiscoveryEnabled)", new Object[0]);
            method.addStatement("\n\nString key = clientConfiguration.option($T.CREDENTIALS_PROVIDER).resolveCredentials().accessKeyId()", new Object[]{AwsClientOption.class});
            method.addStatement("EndpointDiscoveryRequest endpointDiscoveryRequest = $T.builder().required($L).defaultEndpoint(clientConfiguration.option($T.ENDPOINT)).build()", new Object[]{EndpointDiscoveryRequest.class, opModel.getInputShape().getEndpointDiscovery().isRequired(), SdkClientOption.class});
            method.addStatement("cachedEndpoint = $L.get(key, endpointDiscoveryRequest)", new Object[]{"endpointDiscoveryCache"});
            method.endControlFlow();
        }
        method.addStatement("$T<$T> metricPublishers = resolveMetricPublishers(clientConfiguration, $N.overrideConfiguration().orElse(null))", new Object[]{List.class, MetricPublisher.class, opModel.getInput().getVariableName()}).addStatement("$1T apiCallMetricCollector = metricPublishers.isEmpty() ? $2T.create() : $1T.create($3S)", new Object[]{MetricCollector.class, NoOpMetricCollector.class, "ApiCall"});
        method.beginControlFlow("try", new Object[0]).addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "SERVICE_ID", this.model.getMetadata().getServiceId()}).addStatement("apiCallMetricCollector.reportMetric($T.$L, $S)", new Object[]{CoreMetric.class, "OPERATION_NAME", opModel.getOperationName()});
        ClientClassUtils.addS3ArnableFieldCode(opModel, this.model).ifPresent(arg_0 -> ((MethodSpec.Builder)method).addCode(arg_0));
        method.addCode(ClientClassUtils.addEndpointTraitCode(opModel));
        method.addCode(this.protocolSpec.executionHandler(opModel)).endControlFlow().beginControlFlow("finally", new Object[0]).addStatement("metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()))", new Object[0]).endControlFlow();
        methods.add(method.build());
        methods.addAll(this.paginatedMethods(opModel));
        return methods;
    }

    private List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> paginatedMethodSpecs = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            paginatedMethodSpecs.add(SyncClientInterface.operationMethodSignature(this.model, opModel, SimpleMethodOverload.PAGINATED, PaginatorUtils.getPaginatedMethodName(opModel.getMethodName())).addAnnotation(Override.class).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addStatement("return new $T(this, applyPaginatorUserAgent($L))", new Object[]{this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName()), opModel.getInput().getVariableName()}).build());
        }
        return paginatedMethodSpecs;
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addStatement("clientHandler.close()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
    }

    private MethodSpec utilitiesMethod() {
        UtilitiesMethod config = this.model.getCustomizationConfig().getUtilitiesMethod();
        ClassName returnType = PoetUtils.classNameFromFqcn(config.getReturnType());
        String instanceClass = config.getInstanceType();
        if (instanceClass == null) {
            instanceClass = config.getReturnType();
        }
        ClassName instanceType = PoetUtils.classNameFromFqcn(instanceClass);
        return MethodSpec.methodBuilder((String)"utilities").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $T.create($L)", new Object[]{instanceType, String.join((CharSequence)",", config.getCreateMethodParams())}).build();
    }

    static ProtocolSpec getProtocolSpecs(PoetExtensions poetExtensions, IntermediateModel model) {
        Protocol protocol = model.getMetadata().getProtocol();
        switch (protocol) {
            case QUERY: {
                return new QueryProtocolSpec(model, poetExtensions);
            }
            case REST_XML: {
                return new XmlProtocolSpec(model, poetExtensions);
            }
            case EC2: {
                return new Ec2ProtocolSpec(model, poetExtensions);
            }
            case AWS_JSON: 
            case REST_JSON: 
            case CBOR: {
                return new JsonProtocolSpec(poetExtensions, model);
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }

    private MethodSpec resolveMetricPublishersMethod() {
        String clientConfigName = "clientConfiguration";
        String requestOverrideConfigName = "requestOverrideConfiguration";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"resolveMetricPublishers").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class})).addParameter(SdkClientConfiguration.class, clientConfigName, new Modifier[0]).addParameter(RequestOverrideConfiguration.class, requestOverrideConfigName, new Modifier[0]);
        String publishersName = "publishers";
        methodBuilder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{MetricPublisher.class}), publishersName});
        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{requestOverrideConfigName}).addStatement("$N = $N.metricPublishers()", new Object[]{publishersName, requestOverrideConfigName}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null || $1N.isEmpty())", new Object[]{publishersName}).addStatement("$N = $N.option($T.$N)", new Object[]{publishersName, clientConfigName, SdkClientOption.class, "METRIC_PUBLISHERS"}).endControlFlow();
        methodBuilder.beginControlFlow("if ($1N == null)", new Object[]{publishersName}).addStatement("$N = $T.emptyList()", new Object[]{publishersName, Collections.class}).endControlFlow();
        methodBuilder.addStatement("return $N", new Object[]{publishersName});
        return methodBuilder.build();
    }

    private MethodSpec waiterMethod() {
        return MethodSpec.methodBuilder((String)"waiter").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $T.builder().client(this).build()", new Object[]{this.poetExtensions.getSyncWaiterInterface()}).returns((TypeName)this.poetExtensions.getSyncWaiterInterface()).build();
    }
}

